<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Target Listing', 'custom_css' => 'assets/css/add-indicator.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if(session('error')): ?>
    <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>
    <div class="card">
        <div class="card-header cs-card-header">
            <h1 class="page-title">Targets</h1>
            <div class="card-header-action">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Export Target')): ?>
                <a href="<?php echo e(url('targets/export')); ?>" class="btn btn-success btn-sm">
                    Export
                </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Target')): ?>
                <a href="<?php echo e(url('targets/create')); ?>" class="btn btn-primary btn-sm">
                    Add New Target
                </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-body">
            <!-- <div class="graph-filters-strip">
                <div class="filters-area">
                    <div class="form-group cs-form-group">
                        <label for="" class="form-label">Goal</label>
                        <select name="" id="" class="form-select form-select-sm">
                            <option value="">-- Select Goal --</option>
                        </select>
                    </div>
                    <div class="form-group cs-form-group">
                        <label for="" class="form-label">Target</label>
                        <select name="" id="" class="form-select form-select-sm">
                            <option value="">-- Select Target --</option>
                        </select>
                    </div>
                </div>
            </div> -->
            <div class="table-responsive">
                <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                    <colgroup>
                        <col style="width: 950px; max-width:950px;" />
                        <col style="width: 250px; max-width:250px;" />
                        <col style="width: 150px; max-width:150px;" />
                        <col />
                    </colgroup>
                    <thead>
                        <tr>
                            <th>Target Name</th>
                            <th>Goal</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $targets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="p-3">
                                <?php echo e($target->target_name); ?>

                            </td>
                            <td><?php echo e($target->goal_name); ?></td>
                            <td><span class="<?php echo e($target->status =='Active'?'text-success':'text-danger'); ?>"><?php echo e($target->status =='Active'?'Active':'Inactive'); ?></span></td>
                            <td>
                                <a href="<?php echo e(url('targets/'.$target->target_id.'/edit')); ?>" class="cs-icon-edit" data-icon-toggle-title="Edit Target">
                                    <i class="bi bi-pencil-square"></i>
                                </a>
                                <?php if($target->status == 'Active'): ?>
                                <a href="javascript:void(0);" class="cs-icon-delete" data-icon-toggle-title="Discontinue Target" onclick="confirmAction('<?php echo e($target->target_id); ?>','inactive')">
                                    <i class="bi bi-x-lg"></i>
                                </a>
                                <?php else: ?>
                                <a href="javascript:void(0);" class="cs-icon-save" data-icon-toggle-title="Activate Target" onclick="confirmAction('<?php echo e($target->target_id); ?>','active')">
                                    <i class="bi bi-check-lg"></i>
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <nav>
                <ul class="pagination">
                    <?php echo e($targets->links('pagination.bootstrap-4')); ?>

                </ul>
            </nav>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<!-- Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>

<!-- External Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>

<!-- App Script -->
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>

<script src="<?php echo e(asset('assets/js/sweetAlert.js')); ?>"></script>

<script>
    function confirmAction(targetId, action) {
        var url = 'targets/' + targetId + '/' + action + '/delete';
        if (action != '') {
            if (action == 'inactive') {
                var prompt = 'Are you sure to discontinue this Target?';
            } else {
                var prompt = 'Are you sure to activate this Target?';
            }
        } else {
            Swal('Error', 'Action not found', 'error');
        }
        Swal.fire({
            title: prompt,
            text: '',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, do it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        })
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/target/index.blade.php ENDPATH**/ ?>