<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($name); ?></title>
    <style>
        * {
            font-family: Arial, sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 8px;
            text-align: center;
        }

        th {
            background-color: #FFFF00;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <?php if(isset($indicators_data) && !empty($indicators_data) && count($indicators_data) > 0): ?>
    <table>
        <thead>
            <?php if($indicator_type == 'district'): ?>
            <tr>
                <th colspan="5"></th>
                <th colspan="<?php echo e(count($reporting_years)*count($districts)); ?>">Achieved Value</th>
            </tr>
            <?php else: ?>
            <tr>
                <th colspan="5"></th>
                <th colspan="<?php echo e(count($reporting_years)); ?>">Achieved Value</th>
            </tr>
            <?php endif; ?>

            <?php if($indicator_type == 'district'): ?>
            <tr>
                <th colspan="5"></th>
                <?php if(isset($districts) && !empty($districts) && count($districts) > 0): ?>
                <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th colspan="<?php echo e(count($reporting_years)); ?>"><?php echo e($district); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tr>
            <?php endif; ?>

            <tr>
                <th>Goal</th>
                <th>Indicator</th>
                <th>Baseline Year</th>
                <th>Baseline Value</th>
                <?php if($indicator_type == 'district'): ?>
                <th>Target Value</th>
                <?php else: ?>
                <th>Department</th>
                <?php endif; ?>
                <?php if($indicator_type == 'district'): ?>
                <?php if(isset($districts) && !empty($districts) && count($districts) > 0): ?>
                <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($reporting_years) && !empty($reporting_years) && count($reporting_years) > 0): ?>
                <?php $__currentLoopData = $reporting_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $thyear=> $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th><?php echo e($thyear); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php else: ?>
                <?php if(isset($reporting_years) && !empty($reporting_years) && count($reporting_years) > 0): ?>
                <?php $__currentLoopData = $reporting_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th><?php echo e($year); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <!-- Example row, add more rows as needed -->
            <?php $__currentLoopData = $indicators_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($data['goal']); ?></td>
                <td><?php echo e($data['indicator']); ?></td>
                <td><?php echo e($data['baseline_year']); ?></td>
                <td><?php echo e($data['baseline_value']); ?></td>

                <?php if($indicator_type == 'district'): ?>
                <td><?php echo e($data['target_value']); ?></td>
                <?php else: ?>
                <td><?php echo e($data['department']); ?></td>
                <?php endif; ?>

                <?php if($indicator_type == 'district'): ?>
                <?php if(isset($districts) && !empty($districts) && count($districts) > 0): ?>
                <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district_id => $district_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($reporting_years) && !empty($reporting_years) && count($reporting_years) > 0): ?>

                <?php $__currentLoopData = $reporting_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td><?php echo e(isset($data[$district_id][$year]) ? $data[$district_id][$year] : 'N/A'); ?></td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php else: ?>
                <?php if(isset($reporting_years) && !empty($reporting_years) && count($reporting_years) > 0): ?>

                <?php $__currentLoopData = $reporting_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td><?php echo e(isset($data[$year]) ? $data[$year] : 'N/A'); ?></td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php endif; ?>
                <?php endif; ?>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php else: ?>
    <p>No data found</p>
    <?php endif; ?>
</body>

</html><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/export-report/indicators_pdf_report.blade.php ENDPATH**/ ?>