<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Indicator Listing', 'custom_css' => 'assets/css/indicator.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="goals-drawer-wrapper show-drawer" data-goals="drawer-wrapper">
    <div class="page-content">
        <?php if(session('success')): ?>
        <div class="alert alert-success" id="alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <?php if(session('error')): ?>
        <div class="alert alert-danger" id="alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>
        <div class="card">
            <div class="card-header cs-card-header">
                <h1 class="page-title">Indicators Data Entries</h1>
                <div class="card-header-action">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Export Indicator Data Entry')): ?>
                    <?php
                    $url_parameters = [];
                    if(request()->has('goal')) {
                    $url_parameters['goal'] = request('goal');
                    }
                    if(request()->has('target')) {
                    $url_parameters['target'] = request('target');
                    }
                    if(request()->has('type')) {
                    $url_parameters['type'] = request('type');
                    }
                    if(request()->has('district')) {
                    $url_parameters['district'] = request('district');
                    }
                    if(request()->has('department')) {
                    $url_parameters['department'] = request('department');
                    }
                    ?>

                    <a href="<?php echo e(route('indicator_data_entries.export', $url_parameters)); ?>" class="btn btn-success btn-sm me-4">
                        Export
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('indicator_data_entries.filter')); ?>" method="GET" style="width: 100%;" id="filter-form">
                    <div class="graph-filters-strip">
                        <div class="filters-area">
                            <?php if(request('goal')): ?>
                            <input type="hidden" name="goal" value="<?php echo e(request('goal')); ?>">
                            <?php endif; ?>
                            <div class="form-group cs-form-group">
                                <label for="target" class="form-label">Target</label>
                                <select name="target" id="target" class="form-select form-select-sm">
                                    <option value="">-- Select Target --</option>
                                    <?php $__currentLoopData = $targets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($target->target_id); ?>" <?php echo e(request('target') == $target->target_id ? 'selected' : ''); ?>><?php echo e($target->target_number.': '.$target->target_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <?php if(auth()->user()->hasRole('Admin') || auth()->user()->hasRole('Super Admin')): ?>
                            <div class="form-group cs-form-group">
                                <label for="type" class="form-label">Indicator Type</label>
                                <select name="type" id="type" class="form-select form-select-sm" data-field="indicator-type">
                                    <option value="utif" <?php echo e(request('type') == 'utif' ? 'selected' : ''); ?>>UTIF</option>
                                    <option value="dif" <?php echo e(request('type') == 'dif' ? 'selected' : ''); ?>>DIF</option>
                                </select>
                            </div>
                            <div class="form-group cs-form-group <?php if(request('type') == 'dif'): ?>d-none <?php endif; ?>" data-field="dept-column">
                                <label for="department" class="form-label">Department</label>
                                <select name="department" id="department" class="form-select form-select-sm">
                                    <option value="">--Select Department--</option>
                                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($department->id); ?>" <?php echo e(request('department') == $department->id ? 'selected' : ''); ?>><?php echo e($department->department_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group cs-form-group <?php if(request('type') !='dif'): ?>d-none <?php endif; ?>" data-field="district-column">
                                <label for="district" class="form-label">District</label>
                                <select name="district" id="district" class="form-select form-select-sm">
                                    <option value="">--Select District--</option>
                                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($district->id); ?>" <?php echo e(request('district') == $district->id ? 'selected' : ''); ?>><?php echo e($district->district_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <?php endif; ?>
                            <div class="form-group cs-form-group" data-field="status-column">
                                <label for="status" class="form-label">Status</label>
                                <select name="status" id="status" class="form-select form-select-sm">
                                    <option value="">--Select Status--</option>
                                    <option value="Pending" <?php echo e(request('status') == 'Pending' ? 'selected' : ''); ?>>Pending</option>
                                    <option value="Sent_for_level_one_approval" <?php echo e(request('status') == 'Sent_for_level_one_approval' ? 'selected' : ''); ?>>Level 1 Approval Pending</option>
                                    <option value="Approved" <?php echo e(request('status') == 'Approved' ? 'selected' : ''); ?>>Approved</option>
                                    <option value="Disapproved" <?php echo e(request('status') == 'Disapproved' ? 'selected' : ''); ?>>Disapproved</option>
                                    <option value="Sent_for_hod_approval" <?php echo e(request('status') == 'Sent_for_hod_approval' ? 'selected' : ''); ?>>Approval Pending by HOD</option>
                                    <option value="Sent_for_admin_approval" <?php echo e(request('status') == 'Sent_for_admin_approval' ? 'selected' : ''); ?>>Approval Pending by Admin</option>
                                </select>
                            </div>
                            <div class="form-group cs-form-group form-group-btn-lg">
                                <button type="submit" class="btn btn-success btn-sm pt-2 pb-2 ps-3 pe-3">
                                    Submit
                                </button>
                                <a href="<?php echo e(url('indicator-data-entries')); ?>" class="btn btn-danger btn-sm ms-2 pt-2 pb-2 ps-3 pe-3">Clear Filter</a>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="table-responsive" style="max-height: calc(100vh - 235px)">
                    <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                        <colgroup>
                            <col style="width: 100px; min-width: 100px" ; />
                            <col style="width: 350px; min-width: 350px" />
                            <col style="width: 100px; min-width: 100px" />
                            <col style="width: 100px; min-width: 100px" />
                            <col style="width: 100px; min-width: 100px" />
                            <col style="width: 150px; min-width: 150px" />
                            <col style="width: 110px; min-width: 110px" />
                            <col style="width: 150px; min-width: 150px" />
                            <col style="width: 150px; min-width: 150px" />
                            <col style="width: 120px; min-width: 120px" />
                            <col style="width: 100px; min-width: 100px" />
                            <col />
                        </colgroup>
                        <thead>
                            <tr>
                                <th>Sr No.</th>
                                <th>Indicator Name</th>
                                <th>Unit</th>
                                <th>Value Type</th>
                                <th>Baseline Value</th>
                                <th>Baseline Year</th>
                                <th>Target 2030</th>
                                <th>Time Period (Current Year)</th>
                                <?php if(!empty($type) && $type == 'dif'): ?>
                                <th>District</th>
                                <?php else: ?>
                                <th>Department</th>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Update Indicator Data Entry')): ?>
                                <th>Data Value (Current Year)</th>
                                <?php endif; ?>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($indicators) && count($indicators) > 0): ?>
                            <?php $__currentLoopData = $indicators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indicator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(($indicators->currentPage() - 1) * $indicators->perPage() + $loop->iteration); ?></td>
                                <td><?php echo e($indicator->indicator_number); ?>: <?php echo e($indicator->indicator_name); ?></td>
                                <td><?php echo e($indicator->unit); ?></td>
                                <td><?php if(!empty($indicator->value_type)): ?><?php echo e($indicator->value_type); ?> <?php else: ?> <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" style="margin-left: 5px;" alt="No Data" /> <?php endif; ?></td>
                                <td><?php if(!empty($indicator->baseline_value)): ?><?php echo e($indicator->baseline_value); ?> <?php else: ?> <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" style="margin-left: 5px;" alt="No Data" /> <?php endif; ?></td>
                                <td><?php if(!empty($indicator->baseline_year)): ?><?php echo e($indicator->baseline_year); ?> <?php else: ?> <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" style="margin-left: 5px;" alt="No Data" /> <?php endif; ?></td>
                                <td><?php if(!empty($indicator->target_value)): ?><?php echo e($indicator->target_value); ?> <?php else: ?> <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" style="margin-left: 5px;" alt="No Data" /> <?php endif; ?></td>
                                <td><?php if(!empty($indicator->reporting_year)): ?><?php echo e($indicator->reporting_year); ?> <?php else: ?> <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" style="margin-left: 5px;" alt="No Data" /> <?php endif; ?></td>
                                <td>
                                    <?php if(!empty($indicator->district_name)): ?>
                                    <?php echo e($indicator->district_name); ?>

                                    <?php else: ?>
                                    <?php echo e($indicator->department_name); ?>

                                    <?php endif; ?>
                                </td>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Update Indicator Data Entry')): ?>
                                <td>
                                    <div class="form-group cs-form-group mb-0">
                                        <?php
                                        $inputdisable = '';
                                        $user = auth()->user();
                                        ?>
                                        <?php if($user->hasRole('District-User') || $user->hasRole('Department-User')|| $user->hasRole('District-Approver') || $user->hasRole('Department-Approver') || $user->hasRole('District-HOD') || $user->hasRole('Department-HOD')): ?>
                                            <?php if(((strtolower($indicator->status) == 'approved') && $indicator->update_count >= 3)): ?>
                                                <?php
                                                $inputdisable = 'disabled';
                                                ?>
                                            <?php endif; ?>
                                            <?php if((strtolower($indicator->status) == 'sent_for_hod_approval' || strtolower($indicator->status) == 'sent_for_admin_approval') && ($user->hasRole('District-User') || $user->hasRole('Department-User') || $user->hasRole('District-Approver') || $user->hasRole('Department-Approver'))): ?>
                                                <?php
                                                $inputdisable = 'disabled';
                                                ?>
                                            <?php endif; ?>
                                            <?php if(strtolower($indicator->status) == 'sent_for_admin_approval' && ($user->hasRole('District-Approver') || $user->hasRole('Department-Approver') || $user->hasRole('District-HOD') || $user->hasRole('Department-HOD'))): ?>
                                                <?php
                                                $inputdisable = 'disabled';
                                                ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <input type="number" name="data_value" id="indicator_data_entry_id_<?php echo e($indicator->indicator_data_entries_id); ?>" class="form-control form-control-sm" value="<?php echo e($indicator->indicator_value); ?>" oninput="validateInput(this,'<?php echo e($indicator->indicator_data_entries_id); ?>','<?php echo e($indicator->unit); ?>')" <?php echo e($inputdisable); ?> />
                                        <span id="error_<?php echo e($indicator->indicator_data_entries_id); ?>" class="text-danger"></span>
                                        <span id="status_success_indicator_<?php echo e($indicator->indicator_data_entries_id); ?>" class="text-success"></span>
                                        <span id="status_error_indicator_<?php echo e($indicator->indicator_data_entries_id); ?>" class="text-danger"></span>
                                    </div>
                                </td>
                                <?php endif; ?>
                                <td>
                                    <?php if($indicator->status == 'Sent_for_level_one_approval'): ?>
                                        <?php
                                        $text = 'Sent For Level 1 Approval';
                                        $class = 'text-warning';
                                        ?>
                                    <?php elseif($indicator->status == 'Sent_for_hod_approval'): ?>
                                        <?php
                                        $text = 'Sent For HOD Approval';
                                        $class = 'text-warning';
                                        ?>
                                    <?php elseif($indicator->status == 'Sent_for_admin_approval'): ?>
                                        <?php
                                        $text = 'Sent For Admin Approval';
                                        $class = 'text-warning';
                                        ?>
                                    <?php elseif($indicator->status == 'Approved'): ?>
                                        <?php
                                        $text = 'Approved';
                                        $class = 'text-success';
                                        ?>
                                    <?php elseif($indicator->status == 'Disapproved'): ?>
                                        <?php
                                        $text = 'Disapproved';
                                        $class = 'text-danger';
                                        ?>
                                    <?php else: ?>
                                        <?php
                                        $text = 'Pending';
                                        $class = 'text-primary';
                                        ?>
                                    <?php endif; ?>
                                    <div class="status-wrapper">
                                        <span class="<?php echo e($class); ?>" id="status_indicator_<?php echo e($indicator->indicator_data_entries_id); ?>"><?php echo e($text); ?></span>
                                    
                                        <?php if($indicator->status == 'Disapproved' && $indicator->disapproval_reason != null): ?>
                                            <button id="comment_<?php echo e($indicator->indicator_data_entries_id); ?>"
                                                    class="comment-icon-button"
                                                    data-icon-toggle-title="View Comment"
                                                    onclick="displayComment('<?php echo e($indicator->indicator_data_entries_id); ?>', 'showComment', '<?php echo e(addslashes($indicator->disapproval_reason)); ?>')">
                                                <img src="<?php echo e(asset('assets/images/icons8-comment-32-black.png')); ?>" alt="comment" height="15px" width="15px" />
                                            </button>
                                        <?php endif; ?>
                                    </div>                                    
                                </td>
                                <td>
                                    <div class="cs-icons-wrapper">

                                        <?php
                                        $disable = '';
                                        $approve = 'approve';
                                        $disapprove = 'disapprove';
                                        $user = auth()->user();
                                        ?>
                                        <?php if($user->hasRole('District-User') || $user->hasRole('Department-User')|| $user->hasRole('District-Approver') || $user->hasRole('Department-Approver') || $user->hasRole('District-HOD') || $user->hasRole('Department-HOD')): ?>
                                            <?php if(empty($indicator->indicator_value) || (!empty($indicator->status) && (strtolower($indicator->status) == 'approved'  || strtolower($indicator->status) == 'completed') && $indicator->update_count>=3)): ?>
                                                <?php
                                                $disable = 'disabled';
                                                ?>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php if(empty($indicator->indicator_value)): ?>
                                                <?php
                                                $disable = 'disabled';
                                                ?>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Update Indicator Data Entry')): ?>
                                        <button id="save-button_<?php echo e($indicator->indicator_data_entries_id); ?>" class="cs-icon-save cs-icon" <?php echo e($disable); ?> <?php echo e($inputdisable); ?> data-icon-toggle-title="Save" onclick="save('<?php echo e($indicator->indicator_data_entries_id); ?>')">
                                            <i class="bi bi-file-earmark-check"></i>
                                        </button>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Approve Indicator Data Entry')): ?>
                                        <button id="approve_<?php echo e($indicator->indicator_data_entries_id); ?>" class="cs-icon-approve cs-icon" <?php echo e($disable); ?> <?php echo e($inputdisable); ?> data-icon-toggle-title="Approve" onclick="markApproveDisapprove('<?php echo e($indicator->indicator_data_entries_id); ?>','<?php echo e($approve); ?>')">
                                            <svg width="1em" height="1em" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M13 7.70747C12.52 10.1073 10.7105 12.367 8.17148 12.872C6.93314 13.1186 5.64856 12.9682 4.50065 12.4423C3.35274 11.9164 2.40002 11.0417 1.77814 9.94279C1.15626 8.8439 0.896932 7.57681 1.03708 6.32196C1.17722 5.06711 1.70969 3.88845 2.55868 2.95383C4.30002 1.03585 7.24033 0.507885 9.64019 1.46783" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M4.84058 6.7475L7.24044 9.14736L13.0001 2.90771" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </button>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Disapprove Indicator Data Entry')): ?>
                                        <button id="disapprove_<?php echo e($indicator->indicator_data_entries_id); ?>" class="cs-icon-disapprove cs-icon" <?php echo e($disable); ?> <?php echo e($inputdisable); ?> data-icon-toggle-title="Disapprove" onclick="markApproveDisapprove('<?php echo e($indicator->indicator_data_entries_id); ?>','<?php echo e($disapprove); ?>')">
                                            <svg width="1em" height="1em" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M7 13C10.3137 13 13 10.3137 13 7C13 3.68629 10.3137 1 7 1C3.68629 1 1 3.68629 1 7C1 10.3137 3.68629 13 7 13Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M4.75 4.75L9.25 9.25M9.25 4.75L4.75 9.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="11">
                                <?php if(request('goal') == 14): ?>
                                    Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.
                                <?php else: ?>
                                    <?php if(request('goal') == 17): ?>
                                        Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.
                                    <?php else: ?>
                                        No record found
                                    <?php endif; ?>
                                <?php endif; ?>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <nav>
                    <ul class="pagination">
                        <?php echo e($indicators->appends(request()->query())->links('pagination.bootstrap-4')); ?>

                    </ul>
                </nav>
            </div>
        </div>
    </div>
    <?php echo $__env->make('layouts.other.side_goal_filter', ['goals' => $goals,'form_action' => 'indicators.filter','defalut_goal_id'=> $default_goal], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<div id="disapprovalModal" class="disapproval-modal">
    <div class="disapproval-modal-content">
        <span class="close">&times;</span>
        <h2>Enter Disapproval Reason</h2>
        <textarea id="disapprovalReason" rows="5" maxlength="250" placeholder="Please enter disapproval reason here in max 250 characters"></textarea>
        <button id="submitDisapproval" class="btn btn-primary">Submit</button>
    </div>
</div>

<div id="showComment" class="disapproval-modal hidden">
    <div class="disapproval-modal-content">
        <span class="close">&times;</span>
        <h2 class="modal-title">Reason For Disapproval</h2>
        <p id="comment" class="disapproval-reason"></p>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<!-- Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>

<!-- External Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>

<!-- App Script -->
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>

<script src="<?php echo e(asset('assets/js/indicator.js')); ?>"></script>

<script src="<?php echo e(asset('assets/js/plugins/select2.js')); ?>"></script>

<script src="<?php echo e(asset('assets/js/sweetAlert.js')); ?>"></script>
<script>
    $('#target').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    $('#district').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    $('#department').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    $('#type').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    $('#status').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    document.getElementById('filter-form').addEventListener('submit', function(event) {
        event.preventDefault();

        var formData = new FormData(event.target);
        var searchParams = new URLSearchParams(formData);

        if (searchParams.get('type') == 'dif') {
            searchParams.delete('department');
        } else if (searchParams.get('type') == 'utif') {
            searchParams.delete('district');
        }

        window.location = window.location.pathname + '?' + searchParams.toString();
    });

    function validateInput(input, indicator_data_entry_id, unit) {
        var errorSpan = document.getElementById('status_error_indicator_' + indicator_data_entry_id);
        var saveButton = document.getElementById('save-button_' + indicator_data_entry_id);
        var approveButton = document.getElementById('approve_' + indicator_data_entry_id);
        var disapproveButton = document.getElementById('disapprove_' + indicator_data_entry_id);
        var successElement = document.getElementById('status_success_indicator_' + indicator_data_entry_id);
        var input = input.value;
        var unit = unit;
        input = Number(input);
        errorSpan.textContent = '';
        successElement.textContent = '';
        if (unit == 'Percentage' && input > 100) {
            errorSpan.textContent = '';
            errorSpan.textContent = 'Indicator value can not be greater than 100% for Percentage unit';
            saveButton.classList.add('inactive');
            saveButton.disabled = true;
            saveButton.addEventListener('click', preventClick);
            if (approveButton !== null) {
                approveButton.disabled = true;
                approveButton.addEventListener('click', preventClick);
            }
            if (disapproveButton !== null) {
                disapproveButton.disabled = true;
                disapproveButton.addEventListener('click', preventClick);
            }
        }else if(unit == 'Percentage' && input < 0){
            errorSpan.textContent = '';
            errorSpan.textContent = 'Indicator value can not be less than 0% for Percentage unit';
            saveButton.classList.add('inactive');
            saveButton.disabled = true;
            saveButton.addEventListener('click', preventClick);
            if (approveButton !== null) {
                approveButton.disabled = true;
                approveButton.addEventListener('click', preventClick);
            }
            if (disapproveButton !== null) {
                disapproveButton.disabled = true;
                disapproveButton.addEventListener('click', preventClick);
            }
        } else {
            errorSpan.textContent = '';
            saveButton.classList.remove('inactive');
            saveButton.disabled = false;
            approveButton.disabled = false;
            disapproveButton.disabled = false;
            saveButton.removeEventListener('click', preventClick);
            approveButton.removeEventListener('click', preventClick);
            disapproveButton.removeEventListener('click', preventClick);
        }
    }

    function save(indicator_data_entry_id, confirmOverride = false) {
        var inputValue = document.getElementById('indicator_data_entry_id_' + indicator_data_entry_id).value;
        var saveButton = document.getElementById('save-button_' + indicator_data_entry_id);
        var approveButton = document.getElementById('approve_' + indicator_data_entry_id);
        var disapproveButton = document.getElementById('disapprove_' + indicator_data_entry_id);
        var successElement = document.getElementById('status_success_indicator_' + indicator_data_entry_id);
        var errorElement = document.getElementById('status_error_indicator_' + indicator_data_entry_id);
        var statusElement = document.getElementById('status_indicator_' + indicator_data_entry_id);
        var inputElement = document.getElementById('indicator_data_entry_id_' + indicator_data_entry_id);

        if (inputValue === '') {
            successElement.textContent = '';
            errorElement.textContent = 'Indicator value can not be empty';
            return;
        }

        if (isNaN(inputValue)) {
            successElement.textContent = '';
            errorElement.textContent = 'Indicator value must be a number';
            return;
        }

        $.ajax({
            url: '<?php echo e(route("indicator-data-entries.update-indicator-value")); ?>',
            type: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                indicator_data_entry_id: indicator_data_entry_id,
                indicator_value: inputValue,
                confirm_override: confirmOverride ? 1 : 0
            },
            success: function(response) {
                // Handle the warning modal if the value is greater than 20%
                if (response.status === 'error') {
                    Swal.fire({
                        title: 'Are you sure?',
                        text: response.message,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Save Anyway'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Call save function again with confirmOverride set to true
                            save(indicator_data_entry_id, true);
                        }
                    });
                    return;
                }

                if (response.status === 'success') {
                    successElement.textContent = '';
                    errorElement.textContent = '';
                    successElement.textContent = response.message;
                    statusElement.textContent = response.indicator_status;

                    const existingCommentBtn = document.getElementById('comment_' + response.indicator_data_entries_id);
                    if (existingCommentBtn) {
                        existingCommentBtn.remove();
                    }

                    if (response.indicator_status == 'Approved') {
                        statusElement.className = '';
                        statusElement.classList.add('text-success');
                    } else {
                        statusElement.classList.remove('text-primary');
                    }

                    if (response.input_disable == 'yes') {
                        inputElement.disabled = true;
                        saveButton.disabled = true;
                    }
                } else {
                    successElement.textContent = '';
                    errorElement.textContent = response.message;
                    if (response.input_disable == 'yes') {
                        inputElement.disabled = true;
                        saveButton.disabled = true;
                    }
                }
            },
            error: function(response) {
                successElement.textContent = '';
                errorElement.textContent = response.responseJSON.message;
            }
        });
    }

    function preventClick(event) {
        event.preventDefault();
        event.stopPropagation();
    }

    function markApproveDisapprove(indicator_data_entry_id, action) {
        var inputValue = document.getElementById('indicator_data_entry_id_' + indicator_data_entry_id).value;
        var successElement = document.getElementById('status_success_indicator_' + indicator_data_entry_id);
        var errorElement = document.getElementById('status_error_indicator_' + indicator_data_entry_id);
        successElement.textContent = '';
        errorElement.textContent = '';

        if (inputValue === '') {
            errorElement.textContent = 'Indicator value can not be empty';
            return;
        }

        if (isNaN(inputValue) || inputValue > 100) {
            successElement.textContent = '';
            errorElement.textContent = '';
            errorElement.textContent = 'Indicator value must be a number less than or equal to 100';
            return;
        }
        if (action === '') {
            var modal = document.getElementById('disapprovalModal');
            modal.style.display = 'none';
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'You can not approve/disapprove this entry',
            });
            return false;
        }

        var statusElement = document.getElementById('status_indicator_' + indicator_data_entry_id);
        var inputElement = document.getElementById('indicator_data_entry_id_' + indicator_data_entry_id);
        var saveButton = document.getElementById('save-button_' + indicator_data_entry_id);
        var approveButton = document.getElementById('approve_' + indicator_data_entry_id);
        var disapproveButton = document.getElementById('disapprove_' + indicator_data_entry_id);

        if (action === 'approve') {
            Swal.fire({
                title: 'Are you sure?',
                text: 'You want to approve this entry?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, approve it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo e(route("indicator-data-entries.approve-disapprove")); ?>',
                        type: 'POST',
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            indicator_data_entry_id: indicator_data_entry_id,
                            indicator_value: inputValue,
                            action: action // 'approve' or 'disapprove'
                        },
                        success: function(response) {
                            if (response.status === 'success') {
                                const existingCommentBtn = document.getElementById('comment_' + response.indicator_data_entries_id);
                                if (existingCommentBtn) {
                                    existingCommentBtn.remove();
                                }
                                successElement.textContent = '';
                                errorElement.textContent = '';
                                statusElement.textContent = response.indicator_status;
                                if (response.indicator_status == 'Approved') {
                                    statusElement.className = '';
                                    statusElement.classList.add('text-success');
                                } else {
                                    statusElement.classList.remove('text-primary');
                                }
                                if (response.input_disable == 'yes') {
                                    inputElement.disabled = true;
                                    saveButton.disabled = true;
                                    approveButton.disabled = true;
                                    disapproveButton.disabled = true;
                                }
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success',
                                    text: response.message,
                                });
                            } else {
                                successElement.textContent = '';
                                errorElement.textContent = '';
                                if (response.input_disable == 'yes') {
                                    inputElement.disabled = true;
                                    saveButton.disabled = true;
                                    approveButton.disabled = true;
                                    disapproveButton.disabled = true;
                                }
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: response.message,
                                });
                            }
                        },
                        error: function(response) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.responseJSON.message,
                            });
                        }
                    });
                }
            });
        }

        // If action is 'disapprove', show popup with input field
        else if (action === 'disapprove') {
            Swal.fire({
                title: 'Are you sure?',
                text: 'You want to disapprove this entry?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, disapprove it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Show modal
                    var modal = document.getElementById('disapprovalModal');
                    modal.style.display = 'block';

                    // Close modal when clicking on close button or outside modal
                    var closeBtn = document.querySelector('.close');
                    window.onclick = function(event) {
                        if (event.target == modal) {
                            modal.style.display = 'none';
                        }
                    };
                    closeBtn.onclick = function() {
                        modal.style.display = 'none';
                    };

                    // Handle ESC key press to close modal
                    document.addEventListener('keydown', function(event) {
                        if (event.key === 'Escape') {
                            modal.style.display = 'none';
                        }
                    });

                    // Submit disapproval reason
                    var submitBtn = document.getElementById('submitDisapproval');
                    submitBtn.onclick = function() {
                        var disapprovalReason = document.getElementById('disapprovalReason').value.trim();
                        if (disapprovalReason === '') {
                            modal.style.display = 'none';
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'Disapproval reason can not be empty',
                            });
                            return;
                        } else if (disapprovalReason.length > 250) {
                            modal.style.display = 'none';
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'Disapproval reason must be less than 250 characters',
                            });
                            return;
                        }

                        // Send AJAX request with disapproval reason
                        $.ajax({
                            url: '<?php echo e(route("indicator-data-entries.approve-disapprove")); ?>',
                            type: 'POST',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                                indicator_data_entry_id: indicator_data_entry_id,
                                action: action,
                                indicator_value: inputValue,
                                disapproval_reason: disapprovalReason
                            },
                            success: function(response) {
                                if (response.status === 'success') {
                                    modal.style.display = 'none';
                                    statusElement.textContent = response.indicator_status;
                                    if (response.indicator_status == 'Disapproved') {
                                        statusElement.className = '';
                                        statusElement.classList.add('text-danger');
                                        // Clear any existing comment button for this indicator (optional)
                                        const existingCommentBtn = document.getElementById('comment_' + response.indicator_data_entries_id);
                                        if (existingCommentBtn) {
                                            existingCommentBtn.remove();
                                        }

                                        // Only add comment button if disapproval_reason exists and is not empty
                                        if (response.disapproval_reason && response.disapproval_reason.trim() !== '') {
                                            // Create the button element
                                            const commentBtn = document.createElement('button');
                                            commentBtn.id = 'comment_' + response.indicator_data_entries_id;
                                            commentBtn.className = 'comment-icon-button';
                                            commentBtn.setAttribute('data-icon-toggle-title', 'View Comment');
                                            commentBtn.setAttribute('type', 'button');  // good practice for buttons
                                            
                                            // Set onclick attribute to call displayComment with params
                                            // Escape single quotes in disapproval_reason to avoid breaking JS
                                            const escapedReason = response.disapproval_reason.replace(/'/g, "\\'");
                                            commentBtn.setAttribute('onclick', `displayComment('${response.indicator_data_entries_id}', 'showComment', '${escapedReason}')`);
                                            
                                            // Create the img element inside the button
                                            const img = document.createElement('img');
                                            img.src = '<?php echo e(asset('assets/images/icons8-comment-32-black.png')); ?>'; // Adjust if needed
                                            img.alt = 'comment';
                                            img.style.height = '15px';
                                            img.style.width = '15px';
                                            
                                            commentBtn.appendChild(img);

                                            // Append the commentBtn somewhere visible
                                            // For example, next to the statusElement or a container you want
                                            statusElement.parentNode.appendChild(commentBtn);
                                        }
                                    } else {
                                        statusElement.className = '';
                                        statusElement.classList.remove('text-danger');
                                    }
                                    if (response.input_disable == 'yes') {
                                        inputElement.disabled = true;
                                        saveButton.disabled = true;
                                        approveButton.disabled = true;
                                        disapproveButton.disabled = true;
                                    }
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success',
                                        text: response.message,
                                    });
                                } else {
                                    modal.style.display = 'none';
                                    if (response.input_disable == 'yes') {
                                        inputElement.disabled = true;
                                    }
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error',
                                        text: response.message,
                                    });
                                }
                            },
                            error: function(response) {
                                modal.style.display = 'none';
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: response.responseJSON.message,
                                });
                            }
                        });

                        // Close modal after submission
                        modal.style.display = 'none';
                    };

                }
            });
        }

        //#region
        /**
         * Below code handle the height of the SDG goals vertical scrollbar
         * it helps in making the sidebar goals scroll sticky
         */
        window.addEventListener("scroll", () => {
            let drawer = document.querySelector(".goals-drawer");
            let drawerContent = document.querySelector(`.goals-drawer-content`);
            let footer = document.querySelector(".cs-footer");
            let footerTop = footer.getBoundingClientRect().top;
            let drawerBottom = drawer.getBoundingClientRect().bottom;

            if (footerTop < drawerBottom) {
                let diff = 120 + (drawerBottom - footerTop);
                drawerContent.style.height = `calc(100vh - ${diff}px)`;
            } else {
                drawerContent.style.height = `calc(100vh - 120px)`;
            }
        });
        //#endregion
    }

    // Function to display comment in modal
    function displayComment(indicatorId, modalId, comment) {

        // Show modal
        var modal = document.getElementById('showComment');
        modal.style.display = 'block';
        var commentTextArea = document.getElementById('comment');
        commentTextArea.innerText = comment;

        // Close modal when clicking on close button or outside modal
        var closeBtn = document.querySelector('.close');
        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = 'none';
            }
        };
        $('.close').click(function() {
            modal.style.display = 'none';
        });

        // Handle ESC key press to close modal
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                modal.style.display = 'none';
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/indicatorDataEntries/index.blade.php ENDPATH**/ ?>