<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Admin Dashboard', 'custom_css' => 'assets/css/import-export.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">

    <?php if(session('success')): ?>
    <div class="alert alert-success">Data Imported Successfully. Please download response file to check the import status.<a href="<?php echo e(session('success')); ?>" class="btn btn-sm btn-success ms-2" target="blank">Download Response File</a></div>
    <?php endif; ?>

    <?php if(session('allError')): ?>
    <div class="alert alert-danger">Data could not be updated due to errors. Please check the errors in the response file.<a href="<?php echo e(session('allError')); ?>" class="btn btn-sm btn-danger ms-2" target="blank">Download Response File</a></div>
    <?php endif; ?>

    <?php if(session('warning')): ?>
    <div class="alert alert-warning">Some rows could not be updated due to errors. Please check the errors in the response file.<a href="<?php echo e(session('warning')); ?>" class="btn btn-sm btn-warning ms-2" target="blank">Download Response File</a></div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Import/Export</h1>
        </div>
        <div class="card-body">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="upload-wrapper">
                            <div class="upload__icon upload__icon-green">
                                <i class="bi bi-download"></i>
                            </div>
                            <a href="<?php echo e(route('import_export.download_indicators_raw_data')); ?>" class="btn btn-success">
                                Download Data Entry Template
                            </a>
                            <p>
                                <strong>Note:</strong> Please download the template from
                                here to upload the data
                            </p>
                            <div id="" class="error-message"></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="upload-wrapper">
                            <div class="upload__icon">
                                <i class="bi bi-upload"></i>
                            </div>
                            <form action="<?php echo e(route('import_export.import_indicators_raw_data')); ?>" id="uploadForm" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input name="DataEntryTemplate" type="file" id="fileInput">
                            </form>
                            <button type="button" class="btn btn-primary" onclick="document.getElementById('fileInput').click();">
                                Upload Data Entry Form
                            </button>
                            <p>
                                <strong>Note:</strong> Please upload the form downloaded from this page.
                            </p>
                            <div id="errorMessage" class="error-message"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<!-- Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>

<!-- External Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>

<!-- App Script -->
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>

<script>
    document.getElementById('fileInput').addEventListener('change', function(event) {
        const file = event.target.files[0];
        const errorMessage = document.getElementById('errorMessage');
        errorMessage.textContent = '';

        if (file) {
            const allowedExtensions = ['xls', 'xlsx'];
            const fileExtension = file.name.split('.').pop().toLowerCase();
            const maxSizeInMB = 5;
            const maxSizeInBytes = maxSizeInMB * 1024 * 1024;

            if (!allowedExtensions.includes(fileExtension)) {
                errorMessage.textContent = 'Please upload an Excel file (.xls or .xlsx).';
                return;
            }

            if (file.size > maxSizeInBytes) {
                errorMessage.textContent = `File size must be less than ${maxSizeInMB} MB.`;
                return;
            }

            document.getElementById('uploadForm').submit();
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/import-raw-data/index.blade.php ENDPATH**/ ?>