<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Access Control', 'custom_css' =>'assets/css/access-control.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
  <div class="card">
    <div class="card-header">
      <h1 class="page-title">Access Control -> Role : <?php echo e($role->name); ?><a href="<?php echo e(url('roles')); ?>" class="btn btn-danger me-2 float-end">Back</a></h1>
    </div>
    <?php if(session('status')): ?>
    <div class="alert alert-success"><?php echo e(session('status')); ?></div>
    <?php endif; ?>
    <div class="card-body">
      <form action="<?php echo e(url('roles/'.$role->id.'/give-permissions')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="access-control-wrapper">
          <header class="access-control-header">
            <div class="form-group cs-form-group">
              <div class="form-check-wrapper">
                <div class="form-check">
                  <input class="form-check-input" type="checkbox" value="" id="selectAll" data-checkbox="select-all" />
                  <label class="form-check-label" for="selectAll">
                    Select/Deselect All
                  </label>
                </div>
              </div>
            </div>
          </header>
          <div class="access-control-content" data-checkbox="checkboxes">
            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module => $modulePermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="checkbox-row-wrapper">
              <h2 class="sub-heading"><?php echo e($module); ?></h2>
              <div class="checkbox-row">
                <?php $__currentLoopData = $modulePermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="checkbox-item">
                  <div class="form-group cs-form-group">
                    <div class="form-check-wrapper">
                      <div class="form-check">
                        <input class="form-check-input" id="<?php echo e(Str::slug($permission['name'])); ?>" type="checkbox" name="permission[]" value="<?php echo e($permission['name']); ?>" <?php echo e(in_array($permission['id'], $rolePermissions) ? 'checked':''); ?> />
                        <label class="form-check-label" for="<?php echo e(Str::slug($permission['name'])); ?>">
                          <?php echo e($permission['name']); ?>

                        </label>
                      </div>
                    </div>
                  </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>

          <div class="main-action-area m-3">
            <div class="d-flex justify-content-end align-items-center">
              <button type="submit" class="btn btn-success ms-2">
                Save
              </button>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<!-- Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>

<!-- External Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>

<!-- App Script -->
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>

<script src="<?php echo e(asset('assets/js/access-control.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/access-control/role/access_control.blade.php ENDPATH**/ ?>