<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - UTIF Indicator Listing', 'custom_css' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="goals-drawer-wrapper show-drawer" data-goals="drawer-wrapper">
    <div class="page-content">
        <div class="card">
            <div class="card-header cs-card-header">
                <h1 class="page-title">
                    Union Territory Indicator Framework (UTIF)
                </h1>
                <div class="card-header-action pe-2">
                    <a href="<?php echo e(route('graph_dashboard')); ?>" class="btn btn-success btn-sm me-3">
                        Switch to Graph
                    </a>
                </div>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('utif_indicator_listing.filter')); ?>" method="GET" style="width: 100%;" id="filter-form">

                    <?php if(request('goal') && !empty(request('goal'))): ?>
                    <input type="hidden" name="goal" value="<?php echo e(request('goal')); ?>">
                    <?php endif; ?>

                    <?php if(request('department') && !empty(request('department'))): ?>
                    <input type="hidden" name="department" value="<?php echo e(request('department')); ?>">
                    <?php endif; ?>

                    <?php if(request('indicator') && !empty(request('indicator'))): ?>
                    <input type="hidden" name="indicator" value="<?php echo e(request('indicator')); ?>">
                    <?php endif; ?>

                    <div class="filter-dd-area" style="padding-bottom:20px;">
                        <div class="form-group cs-form-group filter-dd__select">
                            <select name="target" id="target" class="form-select form-select-sm">
                                <option value="">-- Select Target --</option>
                                <?php $__currentLoopData = $targets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($target->target_id); ?>" <?php echo e(request('target') == $target->target_id ? 'selected' : ''); ?>><?php echo e($target->target_number.': '.$target->target_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group cs-form-group filter-dd__select">
                            <select name="year" id="year" class="form-select form-select-sm">
                                <option value="">-- Select Year --</option>
                                <?php $__currentLoopData = $indicatoryears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($year); ?>" <?php echo e($filter_year == $year ? 'selected' : ''); ?>><?php echo e($year); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group cs-form-group filter-form-button">
                            <button type="submit" class="btn btn-success btn-sm pt-2 pb-2 ps-3 pe-3">
                                Submit
                            </button>
                            <a href="<?php echo e(route('utif_indicator_listing')); ?>" class="btn btn-danger btn-sm ms-3 me-2 pt-2 pb-2 ps-3 pe-3" style="margin-left:5px;">Clear Filter</a>
                        </div>
                        <div class="form-check form-switch mt-2" style="margin-left:15px;">
                            <label class="form-check-label" for="showUser">Show User</label>
                            <input class="form-check-input" type="checkbox" role="switch" id="showUser" checked />
                        </div>
                        <div class="admin-disputed-icon-div" style="position: absolute;right: 35px;top: 130px;">
                        <span class="admin-disputed-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                            </svg>
                            These are the raw values provided from the source.
                        </span>
                    </div>
                    </div>
                    <div>
                        <div class="table-responsive mb-4">
                        <div class="mobile-admin-disputed-icon-div" style="display: none;">
                            <span class="mobile-admin-disputed-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                    <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                                </svg>
                                These are the raw values provided from the source.
                            </span>
                        </div>
                            <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                                <colgroup>
                                    <col style="width: 50%" />
                                    <col style="width: 260px; min-width: 250px;" />
                                    <col style="width: 100px; min-width: 90px;" />
                                    <col style="width: 130px; min-width: 130px;" />
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th>Indicator</th>
                                        <th>Department Name</th>
                                        <th>Year</th>
                                        <th>Value</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(isset($indicators) && count($indicators) > 0): ?>
                                    <?php $__currentLoopData = $indicators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indicator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($indicator->indicator_number); ?>: <?php echo e($indicator->indicator_name); ?></td>
                                        <td><?php echo e($indicator->department_name); ?></td>
                                        
                                        
                                        <td><?php echo e($indicator->reporting_year); ?></td>
                                        <td>
                                            <?php if(!empty($indicator->indicator_value_comment)): ?>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                                    <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                                                </svg>
                                                <?php echo e($indicator->indicator_value_comment); ?>

                                            <?php else: ?>
                                                <?php if(!empty($indicator->indicator_value)): ?>
                                                    <?php echo e($indicator->indicator_value); ?>

                                                    <?php if(isset($indicator->trend) && !empty($indicator->trend)): ?>
                                                        <?php if($indicator->trend == 'up'): ?>
                                                            <img src="<?php echo e(asset('assets/images/arrow-up.svg')); ?>" alt="Improved" />
                                                        <?php elseif($indicator->trend == 'down'): ?>
                                                            <img src="<?php echo e(asset('assets/images/arrow-down.svg')); ?>" alt="Dropped" />
                                                        <?php elseif($indicator->trend == 'straight'): ?>
                                                            <img src="<?php echo e(asset('assets/images/arrow-straight.svg')); ?>" alt="No Change" />
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                    <a href="#" class="cs-icon-admin ms-3 user-icon" data-icon="user">
                                                        <i class="bi bi-person-fill"></i>
                                                        <div class="user-icon__tooltip">
                                                            <p class="user-reporter">
                                                                <span class="icon-area">
                                                                    <i class="bi bi-person-fill"></i>
                                                                </span>
                                                                <span class="text-area">Reporter: <?php echo e($indicator->reporter_name); ?></span>
                                                            </p>
                                                            <p class="user-approver">
                                                                <span class="icon-area">
                                                                    <i class="bi bi-person-fill"></i>
                                                                </span>
                                                                <span class="text-area">Approver: <?php echo e($indicator->approver_name); ?></span>
                                                            </p>
                                                        </div>
                                                    </a>
                                                <?php else: ?>
                                                <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" alt="No-data" />
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr>
                                        <td colspan="5" class="text-center">
                                            <?php if(request('goal') == 14): ?>
                                                Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.
                                            <?php else: ?>
                                                <?php if(request('goal') == 17): ?>
                                                    Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.
                                                <?php else: ?>
                                                    No record found
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <nav>
                            <ul class="pagination">
                                <?php echo e($indicators->appends(request()->query())->links('pagination.bootstrap-4')); ?>

                            </ul>
                        </nav>
                        <div class="scoring-chart-area">
                            <div class="scoring-chart">
                                <div class="scoring-chart-title">Trend:</div>
                                <div class="chart-scale">
                                    <div class="chart-scale-item">
                                        <p class="chart-scale-title">Improved</p>
                                        <img src="<?php echo e(asset('assets/images/arrow-up.svg')); ?>" alt="Improved" />
                                    </div>
                                    <div class="chart-scale-item">
                                        <p class="chart-scale-title">No Change</p>
                                        <img src="<?php echo e(asset('assets/images/arrow-straight.svg')); ?>" alt="No Change" />
                                    </div>
                                    <div class="chart-scale-item">
                                        <p class="chart-scale-title">Dropped</p>
                                        <img src="<?php echo e(asset('assets/images/arrow-down.svg')); ?>" alt="Dropped" />
                                    </div>
                                    <div class="chart-scale-item">
                                        <p class="chart-scale-title">No Data</p>
                                        <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" alt="No Data" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('layouts.other.side_goal_filter', ['goals' => $goals,'form_action' => 'indicators.filter','defalut_goal_id'=>''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<!-- Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>

<!-- External Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>

<!-- App Script -->
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>
<script src="<?php echo e(asset('assets/js/plugins/select2.js')); ?>"></script>

<script src="<?php echo e(asset('assets/js/sweetAlert.js')); ?>"></script>

<script>
    $('#target').select2({
        tokenSeparators: [',', ' ']
    });

    $('#year').select2({
        tokenSeparators: [',', ' ']
    });
    document.getElementById('filter-form').addEventListener('submit', function(event) {
        event.preventDefault();

        var formData = new FormData(event.target);
        var searchParams = new URLSearchParams(formData);

        window.location = window.location.pathname + '?' + searchParams.toString();
    });
    //#region
    /**
     * Below code handle the height of the SDG goals vertical scrollbar
     * it helps in making the sidebar goals scroll sticky
     */
    window.addEventListener("scroll", () => {
        let drawer = document.querySelector(".goals-drawer");
        let drawerContent = document.querySelector(`.goals-drawer-content`);
        let footer = document.querySelector(".cs-footer");
        let footerTop = footer.getBoundingClientRect().top;
        let drawerBottom = drawer.getBoundingClientRect().bottom;

        if (footerTop < drawerBottom) {
            let diff = 120 + (drawerBottom - footerTop);
            drawerContent.style.height = `calc(100vh - ${diff}px)`;
        } else {
            drawerContent.style.height = `calc(100vh - 120px)`;
        }
    });
    //#endregion
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/utifIndicatorListing/index.blade.php ENDPATH**/ ?>