
<div class="modal-dialog modal-fullscreen">
    <div id="loading">
        <div class="loader simple-loader">
            <div class="loader-body">
                <img src="<?php echo e(asset('assets/images/sdg-loader.gif')); ?>" alt="Loading..." />
            </div>
        </div>
    </div>
    <div class="modal-content">
        <div class="modal-header">
            <h1 class="modal-title fs-5" id="indicator2Label">
                Performance of Indicator
            </h1>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="colored-strips"></div>
        <div class="modal-body">
            <?php if(isset($singleGoaldata) && !empty($singleGoaldata)): ?>
            <?php if($singleGoaldata['goal_id'] == '14' || $singleGoaldata['goal_id'] == '17'): ?>
            <div class="invalid-indicator-wrapper">
                <div class="ii__image">
                    <?php
                    $goal_id = $singleGoaldata['goal_id'];
                    $goal_name = $singleGoaldata['goal_name'];
                    ?>
                    <img src="<?php echo e(asset('assets/images/goals/goal_'.$goal_id.'.jpg')); ?>" alt="<?php echo e($goal_name); ?>" />
                </div>
                <h2 class="invalid-indicator-msg">
                    <?php if($singleGoaldata['goal_id'] == '14'): ?>
                    Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.
                    <?php elseif($singleGoaldata['goal_id'] == '17'): ?>
                    Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.
                    <?php endif; ?>
                </h2>
            </div>
            <?php else: ?>
            <div class="sidebar-table-wrapper">
                <div class="sidebar-table__content-area">
                    <div class="stca__img-area">
                        <?php if(isset($singleGoaldata) && !empty($singleGoaldata)): ?>
                        <?php
                        $goal_id = $singleGoaldata['goal_id'];
                        $goal_name = $singleGoaldata['goal_name'];
                        ?>
                        <input type="hidden" value="<?php echo e($goal_id); ?>" id="goal_id" />
                        <img src="<?php echo e(asset('assets/images/goals/goal_'.$goal_id.'.jpg')); ?>" alt="<?php echo e($goal_name); ?>" />
                        <?php endif; ?>
                    </div>
                    
                    
                </div>
                <div class="sidebar-table__table-content-area" data-toggle-tab>
                    <div class="st__action-wrapper">
                        <nav class="cs-tabs-nav">
                            <button class="btn active" data-toggle-tab-btn="2">UT</button>
                        </nav>
                        <span style="color: #000000;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                            </svg>
                            These are the raw values provided from the source.
                        </span>
                    </div>
                    <div>
                        <div data-toggle-tab-content="2">
                            <div class="table-indicators" style="max-height: calc(100vh - 170px)">
                                <table class="table cs-table-2 cs-table-sticky-header table-striped mb-0" role="grid">
                                    <thead>
                                        <tr>
                                            <th>Indicator</th>
                                            <th>Unit</th>
                                            <?php if(!empty($lastThreeYears)): ?>
                                            <?php $__currentLoopData = $lastThreeYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th><?php echo e($year); ?></th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(isset($goal_utif_indicator_data) && count($goal_utif_indicator_data) > 0): ?>
                                        <?php $__currentLoopData = $goal_utif_indicator_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indicator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <p>
                                                    <?php echo e($indicator['indicator_number']); ?> : <?php echo e($indicator['indicator_name']); ?>

                                                </p>
                                            </td>
                                            <td><?php echo e($indicator['unit']); ?></td>
                                            <?php $__currentLoopData = $utif_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td style="width: 15%;">
                                                <?php if(in_array($year, array_keys($indicator))): ?>
                                                    <?php if(isset($indicator[$year])): ?>
                                                        <?php if(!empty($indicator[$year]['comment'])): ?>
                                                            <span>
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                                                <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                                                            </svg>
                                                            <?php echo e($indicator[$year]['comment']); ?>

                                                            </span>
                                                        <?php else: ?>
                                                            <?php if(!empty($indicator[$year]['score'])): ?>
                                                                <?php echo e(trim($indicator[$year]['score'])); ?>

                                                            <?php else: ?>
                                                                <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" alt="No-data" />
                                                            <?php endif; ?>
                                                            <?php if(isset($indicator[$year]['trend'])): ?>
                                                                <?php if($indicator[$year]['trend'] == 'up'): ?>
                                                                    <img src="<?php echo e(asset('assets/images/arrow-up.svg')); ?>" alt="Increased" />
                                                                <?php elseif($indicator[$year]['trend'] == 'down'): ?>
                                                                    <img src="<?php echo e(asset('assets/images/arrow-down.svg')); ?>" alt="Dropped" />
                                                                <?php elseif($indicator[$year]['trend'] == 'straight'): ?>
                                                                    <img src="<?php echo e(asset('assets/images/arrow-straight.svg')); ?>" alt="No Change" />
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" alt="No-data" />
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" alt="No-data" />
                                                <?php endif; ?>
                                            </td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                        <tr>
                                            <td colspan="21" class="text">No data available</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="trend-score-chart">
                                <p class="trend-score-chart__title">Trend:</p>
                                <div class="trend-score-chart__list">
                                    <div class="trend-score-chart__list-item">
                                        <p class="trend-score-chart__item-title">Improved</p>
                                        <img src="<?php echo e(asset('assets/images/arrow-up.svg')); ?>" alt="Improved" />
                                    </div>
                                    <div class="trend-score-chart__list-item">
                                        <p class="trend-score-chart__item-title">No Change</p>
                                        <img src="<?php echo e(asset('assets/images/arrow-straight.svg')); ?>" alt="No Change" />
                                    </div>
                                    <div class="trend-score-chart__list-item">
                                        <p class="trend-score-chart__item-title">Dropped</p>
                                        <img src="<?php echo e(asset('assets/images/arrow-down.svg')); ?>" alt="Dropped" />
                                    </div>
                                    <div class="trend-score-chart__list-item">
                                        <p class="trend-score-chart__item-title">No Data</p>
                                        <img src="<?php echo e(asset('assets/images/dual-circle.svg')); ?>" alt="No-data" />
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>
<script>
    //#endregion
    $(document).ready(function() {
        $('#year_dropdown').on('change', function() {
            var year = $(this).val();
            var goal_id = $('#goal_id').val();
            var utif_years = $('#utif_years').val(); // get the selected value of the dropdown
            $('.loader').show();
            $.ajax({
                url: "<?php echo e(route('public.dashboard.goal_sdg_indicators_data')); ?>",
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    goal_id: goal_id,
                    year: year,
                    utif_year: utif_years
                },
                success: function(response) {
                    $('#goal_indicator_score').html(response);
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');
                }
            });
        });

        $('#utif_years').on('change', function() {
            var utif_years = $(this).val();
            var goal_id = $('#goal_id').val();
            var dif_year = $('#year_dropdown').val(); // get the selected value of the dropdown
            $('.loader').show();
            $.ajax({
                url: "<?php echo e(route('public.dashboard.goal_sdg_indicators_data')); ?>",
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    goal_id: goal_id,
                    utif_year: utif_years,
                    year: dif_year
                },
                success: function(response) {
                    $('#goal_indicator_score').html(response);
                    let clickedTab = 2;
                    $('[data-toggle-tab-btn]').removeClass("active");
                    $('[data-toggle-tab-btn="2"]').addClass("active");
                    $('[data-toggle-tab-content]').addClass("d-none");
                    $('[data-toggle-tab-content="' + clickedTab + '"]').removeClass("d-none");

                    if (clickedTab == 2) {
                        $('[data-content="know-calculation-btn"]').addClass("d-none");
                        $('[data-content="score-board"]').addClass("d-none");
                        $('[data-content="ut-score-board"]').removeClass("d-none");
                    } else {
                        $('[data-content="know-calculation-btn"]').removeClass("d-none");
                        $('[data-content="score-board"]').removeClass("d-none");
                        $('[data-content="ut-score-board"]').addClass("d-none");
                    }
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');

                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');
                }
            });
        });
    });
</script><?php /**PATH /var/www/html/sdg_jk/resources/views/public_dashboard/goal_indicator_data_for_year_ut.blade.php ENDPATH**/ ?>