<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Permissions', 'custom_css' =>''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <a href="<?php echo e(url('roles')); ?>" class="btn btn-primary mx-1">Roles</a>
    <a href="<?php echo e(url('permissions')); ?>" class="btn btn-info mx-1">Permissions</a>
    <a href="<?php echo e(url('users')); ?>" class="btn btn-warning mx-1">Users</a>
</div>

<div class="container mt-2">
    <div class="row">
        <div class="col-md-12">

            <?php if(session('status')): ?>
            <div class="alert alert-success"><?php echo e(session('status')); ?></div>
            <?php endif; ?>

            <div class="card mt-3">
                <div class="card-header">
                    <h4>Permissions
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Permission')): ?>
                        <a href="<?php echo e(url('permissions/create')); ?>" class="btn btn-sm btn-primary float-end">Add Permission</a>
                        <?php endif; ?>
                    </h4>
                </div>
                <div class="card-body">

                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Name</th>
                                <th width="40%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($permission->id); ?></td>
                                <td><?php echo e($permission->name); ?></td>
                                <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Update Permission')): ?>
                                    <a href="<?php echo e(url('permissions/'.$permission->id.'/edit')); ?>" class="btn btn-sm btn-success">Edit</a>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Delete Permission')): ?>
                                    <a href="<?php echo e(url('permissions/'.$permission->id.'/delete')); ?>" class="btn btn-sm btn-danger mx-2">Delete</a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<!-- Library Bundle Script -->
<script src="assets/js/core/libs.min.js"></script>

<!-- External Library Bundle Script -->
<script src="assets/js/core/external.min.js"></script>

<!-- App Script -->
<script src="assets/js/hope-ui.js" defer></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/access-control/permission/index.blade.php ENDPATH**/ ?>