 

 <?php $__env->startSection('head'); ?>
 <?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - ', 'custom_css' => 'assets/css/dashboard-input.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 <?php $__env->stopSection(); ?>
 
 <?php $__env->startSection('header'); ?>
 <?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 <?php $__env->stopSection(); ?>
 
 <?php $__env->startSection('sidebar'); ?>
 <?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 <?php $__env->stopSection(); ?>
 
 <?php $__env->startSection('footer'); ?>
 <?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 <?php $__env->stopSection(); ?>
 
 <?php $__env->startSection('content'); ?>
     <!-- Page Content Start -->
     <div class="page-content">
         <?php if(session('success')): ?>
             <div class="alert alert-success alert-dismissible fade show" role="alert">
                 <?php echo e(session('success')); ?>

                 <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
             </div>
         <?php endif; ?>
 
         <?php if(session('error')): ?>
             <div class="alert alert-danger alert-dismissible fade show" role="alert">
                 <?php echo e(session('error')); ?>

                 <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
             </div>
         <?php endif; ?>
         <h1 class="page-title mb-3">Dashboard Input</h1>
         <div class="card" data-tab-content="goal">
             <div class="card-body">
                 <p class="text-dark mb-3">
                     Please enter performance in the SDG India Index
                 </p>
                 <div class="container gx-0">
                     <div class="row">
                         <div class="col-lg-5">
                             <form id="add_comparision_data" class="validate_form" method="POST"
                                 action="<?php echo e(route('saveOrUpdateGoalComparison')); ?>">
                                 <?php echo csrf_field(); ?>
                                 <fieldset data-form="1">
                                     <!-- Hidden field for goal ID -->
                                     <input type="hidden" name="goal_id" id="goal_id" value="all">
 
                                     <div class="form-group cs-form-group">
                                         <label for="year_dropdown" class="form-label">Year <em>*</em></label>
                                         <select name="dashboard_input_goal_year" id="dashboard_input_goal_year"
                                             class="form-select" data-goal-year data-rule-required="true">
                                             <option value="">-- Select Year --</option>
                                             <?php $__currentLoopData = $allYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                 <option value="<?php echo e($year->id); ?>"
                                                     <?php echo e((request('dashboard_input_goal_year') &&
                                                         request('dashboard_input_goal_year') == $year->reporting_year_base) ||
                                                     (!request('dashboard_input_goal_year') && isset($default_year) && $default_year->id == $year->id)
                                                         ? 'selected'
                                                         : ''); ?>>
                                                     <?php echo e($year->reporting_year); ?>

                                                 </option>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         </select>
                                         <!-- Display validation error for year -->
                                         <?php $__errorArgs = ['dashboard_input_goal_year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="text-danger"><?php echo e($message); ?></span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>
 
                                     <div class="form-group cs-form-group">
                                         <label for="india_score" class="form-label">India Score <em>*</em></label>
                                         <input type="number" name="india_score" id="india_score" class="form-control"
                                             placeholder="Enter India Score" data-field="india"
                                             value="<?php echo e(old('india_score', 0)); ?>" data-rule-mandatorynumber="true" />
                                         <small class="helper-text">Min Value: 0, Max Value: 100</small>
                                         <!-- Display validation error for India Score -->
                                         <?php $__errorArgs = ['india_score'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="text-danger"><?php echo e($message); ?></span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>
 
                                     <div class="form-group cs-form-group">
                                         <label for="bestPerformingState" class="form-label">Best Performing State
                                             <em>*</em></label>
                                         <select name="bestPerformingState" id="bestPerformingState" class="form-select"
                                             data-field="best-performing-state" data-rule-required="true">
                                             <option value="">-- Select Best Performing State --</option>
                                             <?php $__currentLoopData = $allStates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                 <option value="<?php echo e($state->state_name); ?>">
                                                     <?php echo e($state->state_name); ?></option>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         </select>
                                         <!-- Display validation error for Best Performing State -->
                                         <?php $__errorArgs = ['bestPerformingState'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="text-danger"><?php echo e($message); ?></span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>
 
                                     <div class="form-group cs-form-group d-none"
                                         data-field-wrapper="best-performing-state-input">
                                         <label for="best_state_score" class="form-label">Best Performing State Score
                                             <em>*</em></label>
                                         <input type="number" name="best_state_score" id="best_state_score"
                                             class="form-control" placeholder="Enter Best Performing State Score"
                                             data-field="best-performing-state-input"
                                             value="<?php echo e(old('best_state_score', 0)); ?>" data-rule-mandatorynumber="true" />
                                         <small class="helper-text">Min Value: 0, Max Value: 100</small>
                                         <!-- Display validation error for Best State Score -->
                                         <?php $__errorArgs = ['best_state_score'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="text-danger"><?php echo e($message); ?></span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>
 
                                     <div class="form-group cs-form-group">
                                         <label for="bestPerformingUT" class="form-label">Best Performing UT
                                             <em>*</em></label>
                                         <select name="bestPerformingUT" id="bestPerformingUT" class="form-select"
                                             data-field="best-performing-ut" data-rule-required="true">
                                             <option value="">-- Select Best Performing UT --</option>
                                             <?php $__currentLoopData = $allUts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ut): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                 <option value="<?php echo e($ut->state_name); ?>">
                                                     <?php echo e($ut->state_name); ?></option>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         </select>
                                         <!-- Display validation error for Best Performing State -->
                                         <?php $__errorArgs = ['bestPerformingUT'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="text-danger"><?php echo e($message); ?></span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>
 
                                     <div class="form-group cs-form-group d-none"
                                         data-field-wrapper="best-performing-ut-input">
                                         <label for="best_ut_score" class="form-label">Best Performing UT Score
                                             <em>*</em></label>
                                         <input type="number" name="best_ut_score" id="best_ut_score"
                                             class="form-control" placeholder="Enter Best Performing UT Score"
                                             data-field="best-performing-ut-input"
                                             value="<?php echo e(old('best_ut_score', 0)); ?>" data-rule-mandatorynumber="true" />
                                         <small class="helper-text">Min Value: 0, Max Value: 100</small>
                                         <!-- Display validation error for Best State Score -->
                                         <?php $__errorArgs = ['best_ut_score'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="text-danger"><?php echo e($message); ?></span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>
 
                                     <div class="form-group cs-form-group">
                                         <label for="jammu_and_kashmir_score" class="form-label">Jammu and Kashmir Score <em>*</em></label>
                                         <input type="number" name="jammu_and_kashmir_score" id="jammu_and_kashmir_score" class="form-control"
                                             placeholder="Enter Jammu and Kashmir Score" value="<?php echo e(old('jammu_and_kashmir_score')); ?>" data-rule-mandatorynumber="true"
                                              />
                                     </div>
 
                                     <div class="mt-4 d-flex justify-content-end">
                                         <button type="reset" class="btn btn-muted me-2">
                                             Cancel
                                         </button>
                                         <button type="submit" class="btn btn-success">
                                             Save
                                         </button>
                                     </div>
                                 </fieldset>
                             </form>
                         </div>
                         <div class="col-lg-7">
                             <!-- Goals List -->
                             <div class="map-options-list">
                                 <div class="map-options-sdg-icon active" role="button" data-mc-goal="mc-all">
                                     <img src="assets/images/sdg-wheel-goal.png" />
                                 </div>
                                 <?php $__currentLoopData = $allGoals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <img role="button" src="assets/images/goals/100 x 100/goal_<?php echo e($goal->id); ?>.png"
                                         data-mc-goal="mc-<?php echo e($goal->id); ?>" />
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                             </div>
                             <!-- /Goals List -->
 
                             <!-- Goal Score Header -->
                             <div class="mc-header" data-mc-header="mc-all">
                                 <div class="mc-header-left">Composite Score</div>
                             </div>
                             <!-- /Goal Score Header -->
 
                             <!-- Goal Graph -->
                             <div data-wrapper="graph">
                                 <div id="mc-graph-goal"></div>
                                 <div class="miz-legend-wrapper vertical-ui">
                                     <div class="miz-legend__right">
                                         <div class="color-indicator-charts">
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-skyblue"></div>
                                                 <div class="ci__title">Achiever (100)</div>
                                             </div>
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-green"></div>
                                                 <div class="ci__title">Front Runner (65 - 99)</div>
                                             </div>
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-yellow"></div>
                                                 <div class="ci__title">Performer (50 - 64)</div>
                                             </div>
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-red"></div>
                                                 <div class="ci__title">Aspirant (0 - 49)</div>
                                             </div>
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-grey"></div>
                                                 <div class="ci__title">Information Unavailable</div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 
     <!-- /Page Content End -->
 <?php $__env->stopSection(); ?>
 <?php $__env->startPush('script'); ?>
     <!-- Library Bundle Script -->
     <script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>
 
     <!-- External Library Bundle Script -->
     <script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>
 
     <!-- Dashboard Input Script -->
     <script>
         const comparisionDataUrl = "<?php echo e(route('comparisionData')); ?>";
         const allGoals = <?php echo json_encode($allGoals, 15, 512) ?>;
     </script>
     <script src="<?php echo e(asset('assets/js/dashboard-input.js')); ?>" defer></script>
 
     <!-- App Script -->
     <script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>
 
 
     <script src="<?php echo e(asset('assets/js/validation.js')); ?>"></script>
     <script src="<?php echo e(asset('assets/js/jquery.validate.js')); ?>" defer></script>
 
     <!-- Highcharts -->
     <script src="https://code.highcharts.com/maps/highmaps.js"></script>
     <script src="https://code.highcharts.com/highcharts-more.js"></script>
     <script src="https://code.highcharts.com/maps/modules/exporting.js"></script>
     <script src="https://code.highcharts.com/maps/modules/offline-exporting.js"></script>
     <script src="https://code.highcharts.com/maps/modules/data.js"></script>
     <script src="https://code.highcharts.com/maps/modules/accessibility.js"></script>
     <!-- Indicator JS -->
     <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.min.js" type="text/javascript"></script>
 
     <!-- Jquery UI Script -->
     <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
     <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui-touch-punch/0.2.3/jquery.ui.touch-punch.min.js"></script>
     <script>
        $(document).ready(function() {
            $(".validate_form").validate({
                errorClass: "text-danger",
                submitHandler: function(form) {
                    // If form is valid, submit the form
                    form.submit();
                }
            });
        });
    </script>
 <?php $__env->stopPush(); ?>
 
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/dashboard_input/index.blade.php ENDPATH**/ ?>