<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Add Indicator', 'custom_css' => 'assets/css/add-indicator.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <?php if(session('status')): ?>
    <div class="alert alert-success"><?php echo e(session('status')); ?></div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Indicator Framework</h1>
        </div>
        <div class="card-body">
            <form id="add-indicator" method="POST" action="<?php if(!empty($indicator->id)): ?> <?php echo e(url('indicators/'.$indicator->id)); ?> <?php else: ?> <?php echo e(url('indicators')); ?> <?php endif; ?>">
                <?php echo csrf_field(); ?>
                <?php if(!empty($indicator->id)): ?>
                <input type="hidden" name="indicator_id" value="<?php echo e($indicator->id); ?>">
                <?php echo method_field('PUT'); ?>
                <?php endif; ?>
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label">Select Indicator Type</label>
                                <div class="form-check-wrapper">
                                    <?php
                                    $dif = '';
                                    $utif = '';
                                    ?>
                                    <?php if(old('indicator_type')=='dif' || !empty($indicator->district_id)): ?>
                                    <?php
                                    $dif = 'checked';
                                    ?>
                                    <?php else: ?>
                                    <?php if(old('indicator_type')=='utif' || !empty($indicator->department_id)): ?>
                                    <?php
                                    $utif = 'checked';
                                    ?>
                                    <?php else: ?>
                                    <?php
                                    $utif = 'checked';
                                    ?>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" value="utif" id="flexCheckDefault2" data-checkbox="utif-dept" name="indicator_type" <?php echo e($utif); ?> <?php if($edit): ?> disabled <?php endif; ?> />
                                        <label class="form-check-label" for="flexCheckDefault2">
                                            UTIF
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" value="dif" id="flexCheckChecked" name="indicator_type" data-checkbox="dif-dept" <?php echo e($dif); ?> <?php if($edit): ?> disabled <?php endif; ?> />
                                        <label class="form-check-label" for="flexCheckChecked">
                                            DIF
                                        </label>
                                    </div>
                                    <?php $__errorArgs = ['indicator_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <?php
                            $indicator_number = '';
                            $indicator_name = '';
                            $value_type = '';
                            $baseline_value = '';
                            $target_value = '';
                            ?>
                            <?php if(!empty($indicator->indicator_number)): ?>
                            <?php
                            $indicator_number = $indicator->indicator_number;
                            ?>
                            <?php else: ?>
                            <?php if(!empty(old('indicator_number'))): ?>
                            <?php
                            $indicator_number = old('indicator_number');
                            ?>
                            <?php endif; ?>
                            <?php endif; ?>
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="indicator-id">Indicator Id / Number <em>*</em></label>
                                <input type="text" class="form-control" id="indicator-id" name="indicator_number" placeholder="Enter Indicator Id/Number" data-rule-required='true' value="<?php echo e($indicator_number); ?>" <?php if($edit): ?> disabled <?php endif; ?> />
                            </div>
                            <?php $__errorArgs = ['indicator_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <?php if(!empty($indicator->indicator_name)): ?>
                            <?php
                            $indicator_name = $indicator->indicator_name;
                            ?>
                            <?php else: ?>
                            <?php if(!empty(old('indicator_name'))): ?>
                            <?php
                            $indicator_name = old('indicator_name');
                            ?>
                            <?php endif; ?>
                            <?php endif; ?>
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="indicator-name">Indicator Name <em>*</em></label>
                                <input type="text" class="form-control" id="indicator-name" name="indicator_name" placeholder="Enter Indicator Name" value="<?php echo e($indicator_name); ?>" data-rule-required='true' <?php if($edit): ?> disabled <?php endif; ?> />
                            </div>
                            <?php $__errorArgs = ['indicator_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="goals">Goals <em>*</em></label>
                                <select class="form-select" id="goals" name="goal" data-rule-required="true" <?php if($edit): ?> disabled <?php endif; ?>>
                                    <option value="" selected>-- Select Goal --</option>
                                    <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($goal['goal_id'] != '14' && $goal['goal_id'] != '17'): ?>
                                    <option value="<?php echo e($goal['goal_id']); ?>" <?php if(!empty($indicator->goal_id) && $indicator->goal_id == $goal['goal_id']): ?> selected <?php else: ?> <?php if(!empty(old('goal')) && old('goal')==$goal['goal_id']): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($goal['goal_id']); ?>. <?php echo e($goal['goal_name']); ?></option>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <?php $__errorArgs = ['goal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-no">Target Number <em>*</em></label>
                                <?php if(!empty($targets) && count($targets)>0): ?>
                                <select class="form-select" id="target-no" name="target" data-rule-required='true'>
                                    <option value="" selected>-- Please select Goal first --</option>
                                    <?php $__currentLoopData = $targets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($target->target_id); ?>" <?php if(!empty($indicator->target_id) && $indicator->target_id == $target->target_id): ?> selected <?php else: ?> <?php if(!empty(old('target')) && old('target')==$target->target_id): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($target->target_number); ?>. <?php echo e($target->target_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php else: ?>
                                <select class="form-select" id="target-no" name="target" data-rule-required='true'>
                                    <option value="" selected>-- Please select Goal first --</option>
                                </select>
                                <?php endif; ?>
                            </div>
                            <?php $__errorArgs = ['target'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-12" data-field="assign-department">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="assigning-dept">Assign Department <em>*</em></label>
                                <select class="form-select" id="assigning-dept" name="department" data-rule-required='true' <?php if($edit): ?> disabled <?php endif; ?>>
                                    <option value="" selected>
                                        -- Select Departments --
                                    </option>
                                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($department->id); ?>" <?php if(!empty($indicator->department_id) && $indicator->department_id == $department->id): ?> selected <?php else: ?> <?php if(!empty(old('department')) && old('department')==$department->id): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($department->department_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <?php $__errorArgs = ['department'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="unit">Unit<em>*</em></label>
                                <select class="form-select" id="unit" placeholder="Enter the Unit" name="unit" data-rule-required='true' onchange="showValueType()" <?php if($edit): ?> disabled <?php endif; ?>>
                                    <option value="">--Select Unit--</option>
                                    <option value="absolute" <?php if(!empty(old('unit')) && old('unit')=='absolute' ): ?>) selected <?php else: ?> <?php if(!empty($indicator->unit) && strtolower(trim($indicator->unit)) == 'absolute'): ?> selected <?php endif; ?> <?php endif; ?> >Absolute</option>
                                    <option value="ratio" <?php if(!empty(old('unit')) && old('unit')=='ratio' ): ?>) selected <?php else: ?> <?php if(!empty($indicator->unit) && strtolower(trim($indicator->unit)) == 'ratio'): ?> selected <?php endif; ?> <?php endif; ?>>Ratio</option>
                                    <option value="percentage" <?php if(!empty(old('unit')) && old('unit')=='percentage' ): ?>) selected <?php else: ?> <?php if(!empty($indicator->unit) && strtolower(trim($indicator->unit)) == 'percentage'): ?> selected <?php endif; ?> <?php endif; ?>>Percentage</option>
                                </select>
                            </div>
                            <?php $__errorArgs = ['unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group" id="value-type-div" <?php if(($edit && strtolower($indicator->unit) != 'absolute') || (!empty(old('unit')) && old('unit') !='absolute')): ?> disabled style="display:none;" <?php endif; ?>>
                                <label class="form-label" for="value-type">Value Type<em><?php if(!$edit): ?>* <?php endif; ?></em></label>
                                <select class="form-select" id="indicator-value-type" name="value_type" data-rule-required="true" <?php if($edit): ?> disabled <?php endif; ?>>
                                    <option value="" selected>
                                        -- Select Value types --
                                    </option>
                                    <?php $__currentLoopData = $values_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e(trim($value_type['value'])); ?>" <?php if(!empty(old('value_type')) && old('value_type')==trim($value_type['value'])): ?> selected <?php else: ?> <?php if(!empty($indicator->value_type) && $indicator->value_type == $value_type['value']): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($value_type['value']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <?php $__errorArgs = ['value_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="tags">Indicator Marker<em>*</em></label>
                                <select id="marker" class="form-select" name="marker" data-rule-required='true' <?php if($edit): ?> disabled <?php endif; ?>>
                                    <option value="">--Select Marker--</option>
                                    <option value="positive" <?php if(!empty(old('marker')) && old('marker')=='positive' ): ?>) selected <?php else: ?> <?php if(!empty($indicator->is_positive_indicator) && strtolower(trim($indicator->is_positive_indicator)) == 'positive'): ?> selected <?php endif; ?> <?php endif; ?> >Positive</option>
                                    <option value="negative" <?php if(!empty(old('marker')) && old('marker')=='negative' ): ?>) selected <?php else: ?> <?php if(!empty($indicator->is_positive_indicator) && strtolower(trim($indicator->is_positive_indicator)) == 'negative'): ?> selected <?php endif; ?> <?php endif; ?> >Negative</option>
                                </select>
                            </div>
                            <?php $__errorArgs = ['marker'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="baseline-year">Baseline Year<em>*</em></label>
                                <select class="form-select" id="baseline-year" placeholder="Enter the Baseline Year" name="baseline_year" data-rule-required="true" <?php if($edit): ?> disabled <?php endif; ?>>
                                    <option value="">--Select Year--</option>
                                    <?php $__currentLoopData = $reporting_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($year->id); ?>" <?php if(!empty(old('baseline_year')) && old('baseline_year')==$year->id): ?> selected <?php else: ?> <?php if(!empty($indicator->baseline_year_id) && $indicator->baseline_year_id == $year->id): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($year->reporting_year); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <?php $__errorArgs = ['baseline_year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <?php if(!empty(old('indicator_value'))): ?>
                            <?php
                            $baseline_value = old('indicator_value');
                            ?>
                            <?php else: ?>
                            <?php if(isset($indicator->indicator_value) && !empty($indicator->indicator_value)): ?>
                            <?php
                            $baseline_value = $indicator->indicator_value;
                            ?>
                            <?php endif; ?>
                            <?php endif; ?>
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="indicator-value">Baseline Value<em>*</em></label>
                                <input type="number" class="form-control" id="indicator-value" name="indicator_value" placeholder="Enter the Baseline Value" value="<?php echo e($baseline_value); ?>" data-rule-required='true' data-rule-baselinepercentageRange='true' />
                            </div>
                            <?php $__errorArgs = ['indicator_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <?php if(!empty(old('target_value'))): ?>
                            <?php
                            $target_value = old('target_value');
                            ?>
                            <?php else: ?>
                            <?php if(!empty($indicator->target_value)): ?>
                            <?php
                            $target_value = $indicator->target_value;
                            ?>
                            <?php endif; ?>
                            <?php endif; ?>
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target_value">Target 2030<em>*</em></label>
                                <input type="number" name="target_value" id="target_value" class="form-control" placeholder="Please enter the Target Value" value="<?php echo e($target_value); ?>" data-rule-required='true' data-rule-targetpercentageRange='true' />
                            </div>
                            <?php $__errorArgs = ['target_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="tags">Tags</label>
                                <select id="tags" class="form-select" name="tags[]" multiple placeholder="Add Tags" <?php if($edit): ?> disabled <?php endif; ?>>
                                    <option value="">Search Tags</option>
                                    <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tag->tag); ?>" <?php if(!empty(old('tags')) && in_array($tag->tag, old('tags'))): ?> selected <?php else: ?> <?php if(!empty($indicator->tags) && in_array($tag->tag, explode(',', $indicator->tags))): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($tag->tag); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="my-4 d-flex justify-content-end">
                                <a href="<?php echo e(url()->previous()); ?>" class="btn btn-danger me-2">Cancel</a>
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.validate.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/validation.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>
<script src="<?php echo e(asset('assets/js/add-indicator.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/select2.js')); ?>"></script>
<script>
    $(document).ready(function() {
        $('#tags').select2({
            placeholder: 'Add Tags',
            tags: true,
            tokenSeparators: [',', ' ']
        });

        $('#assigning-dept').select2({
            tokenSeparators: [',', ' ']
        });

        $('#goals').select2({
            tokenSeparators: [',', ' ']
        });

        $('#target-no').select2({
            tokenSeparators: [',', ' ']
        });

        $('#indicator-value-type').select2({
            tokenSeparators: [',', ' ']
        });

        $('#unit').select2({
            tokenSeparators: [',', ' ']
        });
        $('#baseline-year').select2({
            tokenSeparators: [',', ' ']
        });
        $('#marker').select2({
            tokenSeparators: [',', ' ']
        });

        $("#add-indicator").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                // If form is valid, submit the form
                form.submit();
            }
        });

        <?php
        if (old('goal') && !empty(old('goal'))) { ?>
            var goal = <?php echo old('goal'); ?>;
            var target_data = <?php echo old('target'); ?>;
            $.ajax({
                url: "<?php echo e(route('indicators.targets')); ?>",
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    goal_id: goal
                },
                success: function(data) {
                    $('#target-no').empty().append('<option value="">--- Select Target ---</option>');
                    $.each(data, function(index, target) {
                        if (target.target_id == target_data)
                            $('#target-no').append('<option value="' + target.target_id + '" selected>(' + target.target_number + ') ' + target.target_name + '</option>');
                        else
                            $('#target-no').append('<option value="' + target.target_id + '">(' + target.target_number + ') ' + target.target_name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching districts:', error);
                }
            });
        <?php }
        ?>

        // Handle state change event
        $('#goals').change(function() {
            var goal_id = $(this).val();
            // Load targets based on selected goal
            $.ajax({
                url: "<?php echo e(route('indicators.targets')); ?>",
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    goal_id: goal_id
                },
                success: function(data) {
                    $('#target-no').empty().append('<option value="">--- Select Target ---</option>');
                    $.each(data, function(index, target) {
                        $('#target-no').append('<option value="' + target.target_id + '">(' + target.target_number + ') ' + target.target_name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching districts:', error);
                }
            });
        });
        <?php
        if (old('indicator_type') == 'dif' || !empty($indicator->district_id)) { ?>
            // Trigger the click event
            $('[data-checkbox="dif-dept"]').trigger('click');
        <?php } else {
        ?>
            // Trigger the click event
            $('[data-checkbox="utif-dept"]').trigger('click');
        <?php } ?>
    });

    function showValueType() {
        var unit = document.getElementById("unit").value;
        var valueTypeDiv = document.getElementById("value-type-div");
        if (unit === "absolute") {
            valueTypeDiv.style.display = "block";
        } else {
            valueTypeDiv.style.display = "none";
            // Clear the selected value
            document.getElementById("indicator-value-type").selectedIndex = 0;
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/indicator/create.blade.php ENDPATH**/ ?>