@extends('layouts.main_content.public_page_layout')

@section('head')
@include('layouts.head.public_page_head', ['title'=> 'SDG J&K - Dashboard', 'custom_css' => 'assets/css/map-view.css'])
@endsection

@section('header')
@include('layouts.header.public_page_header')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('public_content')
    <div class="back-btn-area">
        <a href="{{route('district_indicator_framework')}}">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                class="bi bi-caret-left-fill" viewBox="0 0 16 16">
                <path
                    d="m3.86 8.753 5.482 4.796c.646.566 1.658.106 1.658-.753V3.204a1 1 0 0 0-1.659-.753l-5.48 4.796a1 1 0 0 0 0 1.506z" />
            </svg>
            Back
        </a>
    </div>
    <section class="listing-section" id="map-section">
        <div class="divisional-cards">
            <div class="divisional-cards-grid">
                <div class="divisional-cards-items">
                    <div class="divisional-cards-title">
                        <h2 class="section-heading">Jammu & Kashmir</h2>
                    </div>
                    <div id="maap"></div>
                </div>
                <div class="divisional-cards-items">
                    <div class="divisional-cards-title">
                        <h2 class="section-heading" data-mc-district="{{ $defaultDistrict['id'] }}">
                            {{ $defaultDistrict['district_name'] }}</h2>
                    </div>
                    <div class="map-controller-wrapper">
                        <div class="mc-options-list">
                            @if (isset($goaldata) && count($goaldata) > 0)
                                @foreach ($goaldata as $goal)
                                    <img role="button"
                                        src="{{ asset('assets/images/goals/goal_' . $goal['goal_id'] . '.jpg') }}"
                                        {{ $goal['goal_id'] == $default_goal['goal_id'] ? 'class=active' : '' }}
                                        data-mc-goal="mc-{{ $goal['goal_id'] }}" />
                                @endforeach
                            @endif
                        </div>
                        <div class="sdg-score-table">
                            @includeWhen(
                                !empty($all_district_sdg_index_data),
                                'public_dashboard.goal_bise_score_for_default_district',
                                [
                                    'all_district_sdg_index_data' => $all_district_sdg_index_data,
                                    'defaultDistrict' => $defaultDistrict,
                                    'default_goal' => $default_goal,
                                    'reportingYears' => $reportingYears,
                                ]
                            )
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('script')
    <!-- Library Bundle Script -->
    <script src="{{ asset('assets/js/core/libs.min.js') }}"></script>

    <!-- App Script -->
    <script src="{{ asset('assets/js/hope-ui.js') }}" defer></script>
    <script src="{{ asset('assets/js/dashboard.js') }}" defer></script>

    <script src="{{ asset('assets/js/map/highmap.js') }}"></script>
    <script src="{{ asset('assets/js/highcharts-more.js') }}"></script>
    <script src="{{ asset('assets/js/map/module/exporting.js') }}"></script>
    <script src="{{ asset('assets/js/map/module/offline_exporting.js') }}"></script>
    <script src="{{ asset('assets/js/map/module/data.js') }}"></script>
    <script src="{{ asset('assets/js/map/module/accessibility.js') }}"></script>

    <script>
        $(document).ready(function() {
            $("[data-banner-button]").click(function() {
                const btnValue = $(this).attr("data-banner-button");
                $("[data-banner-button]").removeClass("active");
                $(this).addClass("active");
                if (btnValue === "ut_index") {
                    $("#sdg-rotating-wheel-handler").addClass("show-rotating-wheel");
                } else {
                    $("#sdg-rotating-wheel-handler").removeClass("show-rotating-wheel");
                }
            });

            var path = window.location.pathname.split('/');
            var index = path.indexOf('dashboard');

            if (index !== -1 && index < path.length - 1) {
                var maap = $('#map-section');
                if (maap.length) {
                    $('html, body').animate({
                        scrollTop: maap.offset().top - 80
                    }, 300);
                }
            }

            $('.mc-options-list img').on('click', function() {
                var goalId = $(this).data('mc-goal').replace('mc-', '');
                var districtId = $('[data-mc-district]').data('mc-district');
                $.ajax({
                    url: "{{ route('public.dashboard.district_sdg_score_for_goal') }}",
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        goal_id: goalId,
                        district_id: districtId
                    },
                    success: function(response) {
                        $('.sdg-score-table').html(response);
                    },
                    error: function(xhr) {
                        console.log(xhr.responseText);
                    },
                    complete: function() {
                        // Hide the loader
                        $('.loader').hide();
                    }
                });
            });

        });

        (async () => {

            const topology = await fetch(
                '{{ asset('assets/js/jk.topo.json') }}'
            ).then(response => response.json());

            // Instantiate the map
            Highcharts.mapChart('maap', {
                chart: {
                    map: topology,
                    spacingBottom: 20
                },

                title: {
                    text: '',
                },

                accessibility: {
                    series: {
                        descriptionFormat: 'SDG Index'
                    },
                    point: {
                        valueDescriptionFormat: '{point.name}.'
                    }
                },

                legend: {
                    enabled: true
                },

                plotOptions: {
                    map: {
                        allAreas: false,
                        joinBy: ['dt_code', 'code'],
                        dataLabels: {
                            enabled: true,
                            color: '#FFFFFF',
                            style: {
                                fontWeight: 'bold'
                            },
                            // Only show dataLabels for areas with high label rank
                            format: '{point.properties.district}'
                        },
                        tooltip: {
                            headerFormat: '',
                            pointFormat: '{point.properties.district}: <b>{series.name}</b>'
                        },
                        point: {
                            events: {
                                click: function() {
                                    // Show loader
                                    document.getElementById('loading').style.display = 'block';
                                    // Get goalId and districtId
                                    var goalId = $('[data-mc-header]').data('mc-header');
                                    if (goalId == undefined) {
                                        goalId = 1;
                                    } else {
                                        goalId = goalId.replace('mc-', '');
                                    }
                                    var districtcode = this.properties.dt_code;
                                    if (districtcode != '991' && districtcode != '992') {
                                        var baseUrl = '{{ url('/district_indicator_framework') }}';
                                        // Change the current URL
                                        window.location.href = `${baseUrl}/${goalId}/${districtcode}`;
                                    }
                                }
                            }
                        },
                    }
                },

                series: [{
                        name: 'Achiever',
                        color: '#00aeef',
                        data: <?php echo json_encode($district_map_data['Achiever']); ?>.map(code => ({
                            code
                        }))
                    }, {
                        name: 'Front Runner',
                        color: '#00a084',
                        data: <?php echo json_encode($district_map_data['Front_Runner']); ?>.map(code => ({
                            code
                        }))
                    }, {
                        name: 'Performer',
                        color: '#ffc40c',
                        data: <?php echo json_encode($district_map_data['Performer']); ?>.map(code => ({
                            code
                        }))
                    }, {
                        name: 'Aspirant',
                        color: '#dd1e47',
                        data: <?php echo json_encode($district_map_data['Aspirant']); ?>.map(code => ({
                            code
                        }))
                    },
                    {
                        name: 'No Data',
                        color: '#cccccc',
                        data: <?php echo json_encode($district_map_data['nodata']); ?>.map(code => ({
                            code
                        }))
                    }
                ],

                credits: false, //used to remove highcharts.com logo
            });

        })();
    </script>
@endpush
