@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - UTIF Indicator Listing', 'custom_css' => ''])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="goals-drawer-wrapper show-drawer" data-goals="drawer-wrapper">
    <div class="page-content">
        <div class="card">
            <div class="card-header cs-card-header">
                <h1 class="page-title">
                    Union Territory Indicator Framework (UTIF)
                </h1>
                <div class="card-header-action pe-2">
                    <a href="{{route('graph_dashboard')}}" class="btn btn-success btn-sm me-3">
                        Switch to Graph
                    </a>
                </div>
            </div>
            <div class="card-body">
                <form action="{{route('utif_indicator_listing.filter')}}" method="GET" style="width: 100%;" id="filter-form">

                    @if(request('goal') && !empty(request('goal')))
                    <input type="hidden" name="goal" value="{{ request('goal') }}">
                    @endif

                    @if(request('department') && !empty(request('department')))
                    <input type="hidden" name="department" value="{{ request('department') }}">
                    @endif

                    @if(request('indicator') && !empty(request('indicator')))
                    <input type="hidden" name="indicator" value="{{ request('indicator') }}">
                    @endif

                    <div class="filter-dd-area" style="padding-bottom:20px;">
                        <div class="form-group cs-form-group filter-dd__select">
                            <select name="target" id="target" class="form-select form-select-sm">
                                <option value="">-- Select Target --</option>
                                @foreach($targets as $target)
                                <option value="{{$target->target_id}}" {{ request('target') == $target->target_id ? 'selected' : '' }}>{{$target->target_number.': '.$target->target_name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group cs-form-group filter-dd__select">
                            <select name="year" id="year" class="form-select form-select-sm">
                                <option value="">-- Select Year --</option>
                                @foreach($indicatoryears as $year)
                                <option value="{{$year}}" {{ $filter_year == $year ? 'selected' : '' }}>{{$year}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group cs-form-group filter-form-button">
                            <button type="submit" class="btn btn-success btn-sm pt-2 pb-2 ps-3 pe-3">
                                Submit
                            </button>
                            <a href="{{ route('utif_indicator_listing') }}" class="btn btn-danger btn-sm ms-3 me-2 pt-2 pb-2 ps-3 pe-3" style="margin-left:5px;">Clear Filter</a>
                        </div>
                        <div class="form-check form-switch mt-2" style="margin-left:15px;">
                            <label class="form-check-label" for="showUser">Show User</label>
                            <input class="form-check-input" type="checkbox" role="switch" id="showUser" checked />
                        </div>
                        <div class="admin-disputed-icon-div" style="position: absolute;right: 35px;top: 130px;">
                        <span class="admin-disputed-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                            </svg>
                            These are the raw values provided from the source.
                        </span>
                    </div>
                    </div>
                    <div>
                        <div class="table-responsive mb-4">
                        <div class="mobile-admin-disputed-icon-div" style="display: none;">
                            <span class="mobile-admin-disputed-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                    <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                                </svg>
                                These are the raw values provided from the source.
                            </span>
                        </div>
                            <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                                <colgroup>
                                    <col style="width: 50%" />
                                    <col style="width: 260px; min-width: 250px;" />
                                    <col style="width: 100px; min-width: 90px;" />
                                    <col style="width: 130px; min-width: 130px;" />
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th>Indicator</th>
                                        <th>Department Name</th>
                                        <th>Year</th>
                                        <th>Value</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(isset($indicators) && count($indicators) > 0)
                                    @foreach($indicators as $indicator)
                                    <tr>
                                        <td>{{$indicator->indicator_number}}: {{$indicator->indicator_name}}</td>
                                        <td>{{$indicator->department_name}}</td>
                                        {{-- commented the below code as there is a need to use the financial year --}}
                                        {{-- @php
                                        $year = explode('-', $indicator->reporting_year);
                                        // $indicator->reporting_year = $year[0];
                                        @endphp --}}
                                        <td>{{$indicator->reporting_year}}</td>
                                        <td>
                                            @if(!empty($indicator->indicator_value_comment))
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                                    <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                                                </svg>
                                                {{$indicator->indicator_value_comment}}
                                            @else
                                                @if(!empty($indicator->indicator_value))
                                                    {{$indicator->indicator_value}}
                                                    @if(isset($indicator->trend) && !empty($indicator->trend))
                                                        @if($indicator->trend == 'up')
                                                            <img src="{{asset('assets/images/arrow-up.svg')}}" alt="Improved" />
                                                        @elseif($indicator->trend == 'down')
                                                            <img src="{{asset('assets/images/arrow-down.svg')}}" alt="Dropped" />
                                                        @elseif($indicator->trend == 'straight')
                                                            <img src="{{asset('assets/images/arrow-straight.svg')}}" alt="No Change" />
                                                        @endif
                                                    @endif
                                                    <a href="#" class="cs-icon-admin ms-3 user-icon" data-icon="user">
                                                        <i class="bi bi-person-fill"></i>
                                                        <div class="user-icon__tooltip">
                                                            <p class="user-reporter">
                                                                <span class="icon-area">
                                                                    <i class="bi bi-person-fill"></i>
                                                                </span>
                                                                <span class="text-area">Reporter: {{$indicator->reporter_name}}</span>
                                                            </p>
                                                            <p class="user-approver">
                                                                <span class="icon-area">
                                                                    <i class="bi bi-person-fill"></i>
                                                                </span>
                                                                <span class="text-area">Approver: {{$indicator->approver_name}}</span>
                                                            </p>
                                                        </div>
                                                    </a>
                                                @else
                                                <img src="{{asset('assets/images/dual-circle.svg')}}" alt="No-data" />
                                                @endif
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="5" class="text-center">
                                            @if(request('goal') == 14)
                                                Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.
                                            @else
                                                @if(request('goal') == 17)
                                                    Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.
                                                @else
                                                    No record found
                                                @endif
                                            @endif
                                        </td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <nav>
                            <ul class="pagination">
                                {{$indicators->appends(request()->query())->links('pagination.bootstrap-4')}}
                            </ul>
                        </nav>
                        <div class="scoring-chart-area">
                            <div class="scoring-chart">
                                <div class="scoring-chart-title">Trend:</div>
                                <div class="chart-scale">
                                    <div class="chart-scale-item">
                                        <p class="chart-scale-title">Improved</p>
                                        <img src="{{asset('assets/images/arrow-up.svg')}}" alt="Improved" />
                                    </div>
                                    <div class="chart-scale-item">
                                        <p class="chart-scale-title">No Change</p>
                                        <img src="{{asset('assets/images/arrow-straight.svg')}}" alt="No Change" />
                                    </div>
                                    <div class="chart-scale-item">
                                        <p class="chart-scale-title">Dropped</p>
                                        <img src="{{asset('assets/images/arrow-down.svg')}}" alt="Dropped" />
                                    </div>
                                    <div class="chart-scale-item">
                                        <p class="chart-scale-title">No Data</p>
                                        <img src="{{asset('assets/images/dual-circle.svg')}}" alt="No Data" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>
    </div>
    @include('layouts.other.side_goal_filter', ['goals' => $goals,'form_action' => 'indicators.filter','defalut_goal_id'=>''])
</div>
@endsection

@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>
<script src="{{asset('assets/js/plugins/select2.js')}}"></script>

<script src="{{asset('assets/js/sweetAlert.js')}}"></script>

<script>
    $('#target').select2({
        tokenSeparators: [',', ' ']
    });

    $('#year').select2({
        tokenSeparators: [',', ' ']
    });
    document.getElementById('filter-form').addEventListener('submit', function(event) {
        event.preventDefault();

        var formData = new FormData(event.target);
        var searchParams = new URLSearchParams(formData);

        window.location = window.location.pathname + '?' + searchParams.toString();
    });
    //#region
    /**
     * Below code handle the height of the SDG goals vertical scrollbar
     * it helps in making the sidebar goals scroll sticky
     */
    window.addEventListener("scroll", () => {
        let drawer = document.querySelector(".goals-drawer");
        let drawerContent = document.querySelector(`.goals-drawer-content`);
        let footer = document.querySelector(".cs-footer");
        let footerTop = footer.getBoundingClientRect().top;
        let drawerBottom = drawer.getBoundingClientRect().bottom;

        if (footerTop < drawerBottom) {
            let diff = 120 + (drawerBottom - footerTop);
            drawerContent.style.height = `calc(100vh - ${diff}px)`;
        } else {
            drawerContent.style.height = `calc(100vh - 120px)`;
        }
    });
    //#endregion
</script>
@endpush