@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Add Target', 'custom_css' => 'assets/css/add-indicator.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
    @if (session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
    @endif
    @if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
        <li>{{$error}}</li>
        @endforeach
    </ul>
    @endif
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Target</h1>
        </div>
        <div class="card-body">
            <form id="create_target" method="POST" action="@if(!empty($target->target_id)) {{url('targets/'.$target->target_id)}} @else {{ url('targets') }} @endif">
                @csrf
                @if(!empty($target->target_id))
                @method('PUT')
                @endif
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="goal">Select Goal <em>*</em></label>
                                <select name="goal" id="goal" class="form-select" data-rule-required="true">
                                    <option value="">-- Select Goal --</option>
                                    @foreach($goals as $goal)
                                    <option value="{{$goal['goal_id']}}" @if(!empty($target) && $target->goal_id == $goal['goal_id']) Selected @else {{old('goal')==$goal['goal_id']?'selected':''}} @endif> {{$goal['goal_id']}}. {{$goal['goal_name']}}</option>
                                    @endforeach
                                </select>
                                @error('goal') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="w-100"></div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-id">Target Id/Number <em>*</em></label>
                                <input type="text" class="form-control" id="target-number" name="target_number" value="@if(!empty($target) && !empty($target->target_number)){{$target->target_number}}@else{{old('target_number')}}@endif" placeholder="Enter Target Id/Number" data-rule-required="true" />
                            </div>
                            @error('target_number') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-name">Target Name <em>*</em></label>
                                <input type="text" class="form-control" id="target-name" name="target_name" value="@if(!empty($target) && !empty($target->target_name)){{$target->target_name}}@else{{old('target_name')}}@endif" placeholder="Enter Target Name" data-rule-required="true" />
                            </div>
                            @error('target_name') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-12">
                            <div class="my-4 d-flex justify-content-end">
                                <a href="{{ url()->previous() }}" class="btn btn-danger me-2">Cancel</a>
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@push('script')
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>
<script src="{{asset('assets/js/core/external.min.js')}}"></script>
<script src="{{ asset('assets/js/jquery.js')}}"></script>
<script src="{{ asset('assets/js/jquery.validate.js') }}"></script>
<script src="{{ asset('assets/js/validation.js') }}"></script>
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>
<script>
    $(document).ready(function() {
        $("#create_target").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                // If form is valid, submit the form
                form.submit();
            }
        });
    });
</script>
@endpush