@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Indicator Listing', 'custom_css' => 'assets/css/indicator.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="goals-drawer-wrapper show-drawer" data-goals="drawer-wrapper">
    @include('layouts.other.side_goal_filter', ['goals' => $goals,'form_action' => 'indicators.filter','defalut_goal_id'=>$default_goal])
    <div class="page-content">
        @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
        @endif
        <div class="card">
            <div class="card-header cs-card-header">
                <h1 class="page-title">Indicators</h1>
                <div class="card-header-action">
                    @can('Export Indicator')
                    <a href="{{route('indicators.export',['goal' => request('goal'), 'target' => request('target'),'type'=> request('type')])}}" class="btn btn-success btn-sm">
                        Export
                    </a>
                    @endcan
                    @can('Create Indicator')
                    <a href="{{url('indicators/create')}}" class="btn btn-primary btn-sm me-4">
                        Add New Indicator
                    </a>
                    @endcan
                </div>
            </div>
            <div class="card-body">
                <div class="graph-filters-strip">
                    <form action="{{route('indicators.filter')}}" method="GET" style="width: 100%;">
                        @if(request('goal'))
                        <input type="hidden" name="goal" value="{{ request('goal') }}">
                        @endif
                        <div class="filters-area">
                            <div class="form-group cs-form-group mr-5">
                                <label for="target" class="form-label">Target</label>
                                <select name="target" id="target" class="form-select form-select-sm">
                                    <option value="">-- Select Target --</option>
                                    @foreach($targets as $target)
                                    <option value="{{$target->target_id}}" {{ request('target') == $target->target_id ? 'selected' : '' }}>{{$target->target_number.': '.$target->target_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group cs-form-group">
                                <label for="type" class="form-label">Indicator Type</label>
                                <select name="type" id="type" class="form-select form-select-sm" data-field="indicator-type">
                                    <option value="">-- Select Indicator Type --</option>
                                    <option value="utif" @if(request('type')=='utif' || $type=='utif' ) selected @endif>UTIF</option>
                                    <option value="dif" @if(request('type')=='dif' || $type=='dif' ) selected @endif>DIF</option>
                                </select>
                            </div>
                            <div class="form-group cs-form-group form-group-btn">
                                <button type="submit" class="btn btn-success btn-sm pt-2 pb-2 ps-3 pe-3">Submit</button>
                                <a href="{{ url('indicators') }}" class="btn btn-danger btn-sm ms-2 pt-2 pb-2 ps-3 pe-3">Clear Filter</a>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="table-responsive">
                    <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Indicator Name</th>
                                <th>Goal</th>
                                <th>Target</th>
                                <th>Baseline Year</th>
                                <th>Unit</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(isset($indicators) && count($indicators) > 0)
                            @foreach($indicators as $indicator)
                            <tr>
                                <td>{{ ($indicators->currentPage() - 1) * $indicators->perPage() + $loop->iteration }}</td>
                                <td>{{$indicator->indicator_number}}: {{$indicator->indicator_name}}</td>
                                <td>{{$indicator->goal_name}}</td>
                                <td>{{$indicator->target_name}}</td>
                                <td>{{$indicator->baseline_year}}</td>
                                <td>{{$indicator->unit}}</td>
                                <td>
                                    @if(strtolower($indicator->is_discontinue) == 'no')
                                    <span class="text-success">Active</span>
                                    @else
                                    <span class="text-danger">Discontinued</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="cs-icons-wrapper">
                                        @if($indicator->is_editable == 'yes')
                                        <a href="{{url('indicators/'.$indicator->indicator_id.'/edit')}}" class="cs-icon-edit" data-icon-toggle-title="Edit">
                                            <i class="bi bi-pencil-square"></i>
                                        </a>
                                        @endif
                                        @if(strtolower($indicator->is_discontinue) == 'no')
                                        <a href="javascript:void(0);" class="cs-icon-delete ms-1" data-icon-toggle-title="Discontinue" onclick="confirmAction('{{$indicator->indicator_id}}','yes')">
                                            <i class="bi bi-x-lg"></i>
                                        </a>
                                        @else
                                        <a href="javascript:void(0);" class="cs-icon-save" data-icon-toggle-title="Activate" onclick="confirmAction('{{$indicator->indicator_id}}','no')">
                                            <i class=" bi bi-check-lg"></i>
                                        </a>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="10">
                                    @if(request('goal') == 14)
                                    Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.
                                    @else
                                    @if(request('goal') == 17)
                                    Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.
                                    @else
                                    No record found
                                    @endif
                                    @endif
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <nav>
                    <ul class="pagination">
                        {{$indicators->appends(request()->query())->links('pagination.bootstrap-4')}}
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>

<script src="{{asset('assets/js/indicator.js')}}"></script>
<script src="{{asset('assets/js/plugins/select2.js')}}"></script>
<script src="{{asset('assets/js/sweetAlert.js')}}"></script>
<script>
    $(document).ready(function() {
        $('#target').select2({
            tags: true,
            tokenSeparators: [',', ' ']
        });
        $('#type').select2({
            tags: true,
            tokenSeparators: [',', ' ']
        });
    });
    //#region
    /**
     * Below code handle the height of the SDG goals vertical scrollbar
     * it helps in making the sidebar goals scroll sticky
     */
    window.addEventListener("scroll", () => {
        let drawer = document.querySelector(".goals-drawer");
        let drawerContent = document.querySelector(`.goals-drawer-content`);
        let footer = document.querySelector(".cs-footer");
        let footerTop = footer.getBoundingClientRect().top;
        let drawerBottom = drawer.getBoundingClientRect().bottom;

        if (footerTop < drawerBottom) {
            let diff = 120 + (drawerBottom - footerTop);
            drawerContent.style.height = `calc(100vh - ${diff}px)`;
        } else {
            drawerContent.style.height = `calc(100vh - 120px)`;
        }
    });
    //#endregion
    function confirmAction(indicatorId, action) {
        var url = 'indicators/' + indicatorId + '/' + action + '/delete';
        if (action != '') {
            if (action == 'yes') {
                var message = 'Are you sure to discontinue this indicator?';
                var prompt = 'This indicator consists of values in it';
            } else {
                var prompt = 'Are you sure to activate this indicator?';
                var message = '';
            }
        } else {
            Swal('Error', 'Action not found', 'error');
        }
        Swal.fire({
            title: prompt,
            text: message,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, do it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        })
    }
</script>
@endpush