@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Add Indicator', 'custom_css' => 'assets/css/add-indicator.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
    @if (session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
    @endif
    @if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
        <li>{{$error}}</li>
        @endforeach
    </ul>
    @endif
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Indicator Framework</h1>
        </div>
        <div class="card-body">
            <form id="add-indicator" method="POST" action="@if(!empty($indicator->id)) {{url('indicators/'.$indicator->id)}} @else {{url('indicators')}} @endif">
                @csrf
                @if(!empty($indicator->id))
                <input type="hidden" name="indicator_id" value="{{$indicator->id}}">
                @method('PUT')
                @endif
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label">Select Indicator Type</label>
                                <div class="form-check-wrapper">
                                    @php
                                    $dif = '';
                                    $utif = '';
                                    @endphp
                                    @if(old('indicator_type')=='dif' || !empty($indicator->district_id))
                                    @php
                                    $dif = 'checked';
                                    @endphp
                                    @else
                                    @if(old('indicator_type')=='utif' || !empty($indicator->department_id))
                                    @php
                                    $utif = 'checked';
                                    @endphp
                                    @else
                                    @php
                                    $utif = 'checked';
                                    @endphp
                                    @endif
                                    @endif
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" value="utif" id="flexCheckDefault2" data-checkbox="utif-dept" name="indicator_type" {{$utif}} @if($edit) disabled @endif />
                                        <label class="form-check-label" for="flexCheckDefault2">
                                            UTIF
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" value="dif" id="flexCheckChecked" name="indicator_type" data-checkbox="dif-dept" {{$dif}} @if($edit) disabled @endif />
                                        <label class="form-check-label" for="flexCheckChecked">
                                            DIF
                                        </label>
                                    </div>
                                    @error('indicator_type') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            @php
                            $indicator_number = '';
                            $indicator_name = '';
                            $value_type = '';
                            $baseline_value = '';
                            $target_value = '';
                            @endphp
                            @if(!empty($indicator->indicator_number))
                            @php
                            $indicator_number = $indicator->indicator_number;
                            @endphp
                            @else
                            @if(!empty(old('indicator_number')))
                            @php
                            $indicator_number = old('indicator_number');
                            @endphp
                            @endif
                            @endif
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="indicator-id">Indicator Id / Number <em>*</em></label>
                                <input type="text" class="form-control" id="indicator-id" name="indicator_number" placeholder="Enter Indicator Id/Number" data-rule-required='true' value="{{$indicator_number}}" @if($edit) disabled @endif />
                            </div>
                            @error('indicator_number') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            @if(!empty($indicator->indicator_name))
                            @php
                            $indicator_name = $indicator->indicator_name;
                            @endphp
                            @else
                            @if(!empty(old('indicator_name')))
                            @php
                            $indicator_name = old('indicator_name');
                            @endphp
                            @endif
                            @endif
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="indicator-name">Indicator Name <em>*</em></label>
                                <input type="text" class="form-control" id="indicator-name" name="indicator_name" placeholder="Enter Indicator Name" value="{{$indicator_name}}" data-rule-required='true' @if($edit) disabled @endif />
                            </div>
                            @error('indicator_number') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="goals">Goals <em>*</em></label>
                                <select class="form-select" id="goals" name="goal" data-rule-required="true" @if($edit) disabled @endif>
                                    <option value="" selected>-- Select Goal --</option>
                                    @foreach($goals as $goal)
                                    @if($goal['goal_id'] != '14' && $goal['goal_id'] != '17')
                                    <option value="{{$goal['goal_id']}}" @if(!empty($indicator->goal_id) && $indicator->goal_id == $goal['goal_id']) selected @else @if(!empty(old('goal')) && old('goal')==$goal['goal_id']) selected @endif @endif>{{$goal['goal_id']}}. {{$goal['goal_name']}}</option>
                                    @endif
                                    @endforeach
                                </select>
                            </div>
                            @error('goal') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-no">Target Number <em>*</em></label>
                                @if(!empty($targets) && count($targets)>0)
                                <select class="form-select" id="target-no" name="target" data-rule-required='true'>
                                    <option value="" selected>-- Please select Goal first --</option>
                                    @foreach($targets as $target)
                                    <option value="{{$target->target_id}}" @if(!empty($indicator->target_id) && $indicator->target_id == $target->target_id) selected @else @if(!empty(old('target')) && old('target')==$target->target_id) selected @endif @endif>{{$target->target_number}}. {{$target->target_name}}</option>
                                    @endforeach
                                </select>
                                @else
                                <select class="form-select" id="target-no" name="target" data-rule-required='true'>
                                    <option value="" selected>-- Please select Goal first --</option>
                                </select>
                                @endif
                            </div>
                            @error('target') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-12" data-field="assign-department">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="assigning-dept">Assign Department <em>*</em></label>
                                <select class="form-select" id="assigning-dept" name="department" data-rule-required='true' @if($edit) disabled @endif>
                                    <option value="" selected>
                                        -- Select Departments --
                                    </option>
                                    @foreach($departments as $department)
                                    <option value="{{$department->id}}" @if(!empty($indicator->department_id) && $indicator->department_id == $department->id) selected @else @if(!empty(old('department')) && old('department')==$department->id) selected @endif @endif>{{$department->department_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            @error('department') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="unit">Unit<em>*</em></label>
                                <select class="form-select" id="unit" placeholder="Enter the Unit" name="unit" data-rule-required='true' onchange="showValueType()" @if($edit) disabled @endif>
                                    <option value="">--Select Unit--</option>
                                    <option value="absolute" @if(!empty(old('unit')) && old('unit')=='absolute' )) selected @else @if(!empty($indicator->unit) && strtolower(trim($indicator->unit)) == 'absolute') selected @endif @endif >Absolute</option>
                                    <option value="ratio" @if(!empty(old('unit')) && old('unit')=='ratio' )) selected @else @if(!empty($indicator->unit) && strtolower(trim($indicator->unit)) == 'ratio') selected @endif @endif>Ratio</option>
                                    <option value="percentage" @if(!empty(old('unit')) && old('unit')=='percentage' )) selected @else @if(!empty($indicator->unit) && strtolower(trim($indicator->unit)) == 'percentage') selected @endif @endif>Percentage</option>
                                </select>
                            </div>
                            @error('unit') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group" id="value-type-div" @if(($edit && strtolower($indicator->unit) != 'absolute') || (!empty(old('unit')) && old('unit') !='absolute')) disabled style="display:none;" @endif>
                                <label class="form-label" for="value-type">Value Type<em>@if(!$edit)* @endif</em></label>
                                <select class="form-select" id="indicator-value-type" name="value_type" data-rule-required="true" @if($edit) disabled @endif>
                                    <option value="" selected>
                                        -- Select Value types --
                                    </option>
                                    @foreach($values_types as $value_type)
                                    <option value="{{trim($value_type['value'])}}" @if(!empty(old('value_type')) && old('value_type')==trim($value_type['value'])) selected @else @if(!empty($indicator->value_type) && $indicator->value_type == $value_type['value']) selected @endif @endif>{{$value_type['value']}}</option>
                                    @endforeach
                                </select>
                            </div>
                            @error('value_type')<span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="tags">Indicator Marker<em>*</em></label>
                                <select id="marker" class="form-select" name="marker" data-rule-required='true' @if($edit) disabled @endif>
                                    <option value="">--Select Marker--</option>
                                    <option value="positive" @if(!empty(old('marker')) && old('marker')=='positive' )) selected @else @if(!empty($indicator->is_positive_indicator) && strtolower(trim($indicator->is_positive_indicator)) == 'positive') selected @endif @endif >Positive</option>
                                    <option value="negative" @if(!empty(old('marker')) && old('marker')=='negative' )) selected @else @if(!empty($indicator->is_positive_indicator) && strtolower(trim($indicator->is_positive_indicator)) == 'negative') selected @endif @endif >Negative</option>
                                </select>
                            </div>
                            @error('marker') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="baseline-year">Baseline Year<em>*</em></label>
                                <select class="form-select" id="baseline-year" placeholder="Enter the Baseline Year" name="baseline_year" data-rule-required="true" @if($edit) disabled @endif>
                                    <option value="">--Select Year--</option>
                                    @foreach($reporting_years as $year)
                                    <option value="{{$year->id}}" @if(!empty(old('baseline_year')) && old('baseline_year')==$year->id) selected @else @if(!empty($indicator->baseline_year_id) && $indicator->baseline_year_id == $year->id) selected @endif @endif>{{$year->reporting_year}}</option>
                                    @endforeach
                                </select>
                            </div>
                            @error('baseline_year') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            @if(!empty(old('indicator_value')))
                            @php
                            $baseline_value = old('indicator_value');
                            @endphp
                            @else
                            @if(isset($indicator->indicator_value) && !empty($indicator->indicator_value))
                            @php
                            $baseline_value = $indicator->indicator_value;
                            @endphp
                            @endif
                            @endif
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="indicator-value">Baseline Value<em>*</em></label>
                                <input type="number" class="form-control" id="indicator-value" name="indicator_value" placeholder="Enter the Baseline Value" value="{{$baseline_value}}" data-rule-required='true' data-rule-baselinepercentageRange='true' />
                            </div>
                            @error('indicator_value') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            @if(!empty(old('target_value')))
                            @php
                            $target_value = old('target_value');
                            @endphp
                            @else
                            @if(!empty($indicator->target_value))
                            @php
                            $target_value = $indicator->target_value;
                            @endphp
                            @endif
                            @endif
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target_value">Target 2030<em>*</em></label>
                                <input type="number" name="target_value" id="target_value" class="form-control" placeholder="Please enter the Target Value" value="{{$target_value}}" data-rule-required='true' data-rule-targetpercentageRange='true' />
                            </div>
                            @error('target_value') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="tags">Tags</label>
                                <select id="tags" class="form-select" name="tags[]" multiple placeholder="Add Tags" @if($edit) disabled @endif>
                                    <option value="">Search Tags</option>
                                    @foreach($tags as $tag)
                                    <option value="{{$tag->tag}}" @if(!empty(old('tags')) && in_array($tag->tag, old('tags'))) selected @else @if(!empty($indicator->tags) && in_array($tag->tag, explode(',', $indicator->tags))) selected @endif @endif>{{$tag->tag}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="my-4 d-flex justify-content-end">
                                <a href="{{ url()->previous() }}" class="btn btn-danger me-2">Cancel</a>
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@push('script')
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>
<script src="{{asset('assets/js/core/external.min.js')}}"></script>
<script src="{{ asset('assets/js/jquery.js')}}"></script>
<script src="{{ asset('assets/js/jquery.validate.js') }}"></script>
<script src="{{ asset('assets/js/validation.js') }}"></script>
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>
<script src="{{asset('assets/js/add-indicator.js')}}"></script>
<script src="{{asset('assets/js/plugins/select2.js')}}"></script>
<script>
    $(document).ready(function() {
        $('#tags').select2({
            placeholder: 'Add Tags',
            tags: true,
            tokenSeparators: [',', ' ']
        });

        $('#assigning-dept').select2({
            tokenSeparators: [',', ' ']
        });

        $('#goals').select2({
            tokenSeparators: [',', ' ']
        });

        $('#target-no').select2({
            tokenSeparators: [',', ' ']
        });

        $('#indicator-value-type').select2({
            tokenSeparators: [',', ' ']
        });

        $('#unit').select2({
            tokenSeparators: [',', ' ']
        });
        $('#baseline-year').select2({
            tokenSeparators: [',', ' ']
        });
        $('#marker').select2({
            tokenSeparators: [',', ' ']
        });

        $("#add-indicator").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                // If form is valid, submit the form
                form.submit();
            }
        });

        <?php
        if (old('goal') && !empty(old('goal'))) { ?>
            var goal = <?php echo old('goal'); ?>;
            var target_data = <?php echo old('target'); ?>;
            $.ajax({
                url: "{{ route('indicators.targets') }}",
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    goal_id: goal
                },
                success: function(data) {
                    $('#target-no').empty().append('<option value="">--- Select Target ---</option>');
                    $.each(data, function(index, target) {
                        if (target.target_id == target_data)
                            $('#target-no').append('<option value="' + target.target_id + '" selected>(' + target.target_number + ') ' + target.target_name + '</option>');
                        else
                            $('#target-no').append('<option value="' + target.target_id + '">(' + target.target_number + ') ' + target.target_name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching districts:', error);
                }
            });
        <?php }
        ?>

        // Handle state change event
        $('#goals').change(function() {
            var goal_id = $(this).val();
            // Load targets based on selected goal
            $.ajax({
                url: "{{ route('indicators.targets') }}",
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    goal_id: goal_id
                },
                success: function(data) {
                    $('#target-no').empty().append('<option value="">--- Select Target ---</option>');
                    $.each(data, function(index, target) {
                        $('#target-no').append('<option value="' + target.target_id + '">(' + target.target_number + ') ' + target.target_name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching districts:', error);
                }
            });
        });
        <?php
        if (old('indicator_type') == 'dif' || !empty($indicator->district_id)) { ?>
            // Trigger the click event
            $('[data-checkbox="dif-dept"]').trigger('click');
        <?php } else {
        ?>
            // Trigger the click event
            $('[data-checkbox="utif-dept"]').trigger('click');
        <?php } ?>
    });

    function showValueType() {
        var unit = document.getElementById("unit").value;
        var valueTypeDiv = document.getElementById("value-type-div");
        if (unit === "absolute") {
            valueTypeDiv.style.display = "block";
        } else {
            valueTypeDiv.style.display = "none";
            // Clear the selected value
            document.getElementById("indicator-value-type").selectedIndex = 0;
        }
    }
</script>
@endpush
@endsection