<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{$name}}</title>
    <style>
        * {
            font-family: Arial, sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 8px;
            text-align: center;
        }

        th {
            background-color: #FFFF00;
            font-weight: bold;
        }
    </style>
</head>

<body>
    @if(isset($indicators_data) && !empty($indicators_data) && count($indicators_data) > 0)
    <table>
        <thead>
            @if($indicator_type == 'district')
            <tr>
                <th colspan="5"></th>
                <th colspan="{{count($reporting_years)*count($districts)}}">Achieved Value</th>
            </tr>
            @else
            <tr>
                <th colspan="5"></th>
                <th colspan="{{count($reporting_years)}}">Achieved Value</th>
            </tr>
            @endif

            @if($indicator_type == 'district')
            <tr>
                <th colspan="5"></th>
                @if(isset($districts) && !empty($districts) && count($districts) > 0)
                @foreach($districts as $id => $district)
                <th colspan="{{count($reporting_years)}}">{{$district}}</th>
                @endforeach
                @endif
            </tr>
            @endif

            <tr>
                <th>Goal</th>
                <th>Indicator</th>
                <th>Baseline Year</th>
                <th>Baseline Value</th>
                @if($indicator_type == 'district')
                <th>Target Value</th>
                @else
                <th>Department</th>
                @endif
                @if($indicator_type == 'district')
                @if(isset($districts) && !empty($districts) && count($districts) > 0)
                @foreach($districts as $id => $district)
                @if(isset($reporting_years) && !empty($reporting_years) && count($reporting_years) > 0)
                @foreach($reporting_years as $thyear=> $year)
                <th>{{$thyear}}</th>
                @endforeach
                @endif
                @endforeach
                @endif
                @else
                @if(isset($reporting_years) && !empty($reporting_years) && count($reporting_years) > 0)
                @foreach($reporting_years as $year)
                <th>{{$year}}</th>
                @endforeach
                @endif
                @endif
            </tr>
        </thead>
        <tbody>
            <!-- Example row, add more rows as needed -->
            @foreach($indicators_data as $data)
            <tr>
                <td>{{$data['goal']}}</td>
                <td>{{$data['indicator']}}</td>
                <td>{{$data['baseline_year']}}</td>
                <td>{{$data['baseline_value']}}</td>

                @if($indicator_type == 'district')
                <td>{{$data['target_value']}}</td>
                @else
                <td>{{$data['department']}}</td>
                @endif

                @if($indicator_type == 'district')
                @if(isset($districts) && !empty($districts) && count($districts) > 0)
                @foreach($districts as $district_id => $district_data)
                @if(isset($reporting_years) && !empty($reporting_years) && count($reporting_years) > 0)

                @foreach($reporting_years as $year)
                <td>{{ isset($data[$district_id][$year]) ? $data[$district_id][$year] : 'N/A' }}</td>
                @endforeach

                @endif
                @endforeach
                @endif
                @else
                @if(isset($reporting_years) && !empty($reporting_years) && count($reporting_years) > 0)

                @foreach($reporting_years as $year)
                <td>{{ isset($data[$year]) ? $data[$year] : 'N/A' }}</td>
                @endforeach

                @endif
                @endif
            </tr>
            @endforeach
        </tbody>
    </table>
    @else
    <p>No data found</p>
    @endif
</body>

</html>