@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Export Report', 'custom_css' => 'assets/css/export-report.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
    @if (!empty($error))
    <ul class="alert alert-warning">
        <li>{{$error}}</li>
    </ul>
    @endif
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Report</h1>
        </div>
        <div class="card-body">
            <div class="report-tab-wrapper" data-toggle-tab>
                <nav class="report-tab-nav">
                    <ul>
                        @if($user->hasRole('Admin') || $user->hasRole('Super Admin'))
                        <li>
                            <button type="button" class="btn active" data-toggle-tab-btn="1">
                                Financial Year Wise
                            </button>
                        </li>
                        <input type="hidden" name="include-radio-button-js" value="yes">
                        @endif
                        @if($user->hasRole('Admin') || $user->hasRole('Super Admin') || $user->hasRole('Department-User') || $user->hasRole('Department-Approver'))
                        <li>
                            <button type="button" class="btn @if($user->hasRole('Department-User') || $user->hasRole('Department-Approver') || $user->hasRole('Department-HOD')) active @endif" data-toggle-tab-btn="2">
                                @if($user->hasRole('Department-User') || $user->hasRole('Department-Approver'))
                                Department Wise Report
                                @else
                                Department Wise
                                @endif
                            </button>
                        </li>
                        @endif
                        @if($user->hasRole('Admin') || $user->hasRole('Super Admin') || $user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD'))
                        <li>
                            <button type="button" class="btn @if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD')) active @endif" data-toggle-tab-btn="3">
                                @if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD'))
                                District Wise Report
                                @else
                                District Wise
                                @endif
                            </button>
                        </li>
                        @endif
                    </ul>
                </nav>
                <div class="report-tab-body">
                    <div class="report-tab-item" data-toggle-tab-content="1">
                        <form id="form1" method="GET" action="{{route('export_report.export_data')}}">
                            <!-- @csrf -->
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="financial_year1" class="form-label">Financial Year <em>*</em></label>
                                            <select name="financial_year1[]" id="financial_year1" class="form-select" multiple data-rule-multiselectDropdown="true">
                                                @if(isset($financialYears) && !empty($financialYears))
                                                <option value="all" {{ (request('financial_year1') && in_array('all', request('financial_year1'))) ? 'selected' : '' }}>All</option>
                                                @foreach($financialYears as $financialYear)
                                                <option value="{{$financialYear}}" {{ (request('financial_year1') && in_array($financialYear, request('financial_year1'))) ? 'selected' : '' }}>{{$financialYear}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('financial_year1') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="goal1" class="form-label">Goal <em>*</em></label>
                                            <select name="goal1[]" id="goal1" class="form-select" multiple data-rule-multiselectDropdown="true">
                                                @if(isset($goals) && !empty($goals))
                                                <option value="all" {{ (request('goal1') && in_array('all', request('goal1'))) ? 'selected' : '' }}>All</option>
                                                @foreach($goals as $goal)
                                                <option value="{{$goal['goal_id']}}" {{ (request('goal1') && in_array($goal['goal_id'], request('goal1'))) ? 'selected' : '' }}>{{$goal['goal_name']}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('goal1') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    @if($user->hasRole('Admin') || $user->hasRole('Super Admin'))
                                    <div class="col-lg-3 col-md-6 @if(request('department1'))d-none @endif" data-field="district-1">
                                        <div class="form-group cs-form-group">
                                            <label for="district1" class="form-label">District <em>*</em></label>
                                            <select name="district1[]" id="district1" class="form-select" multiple data-rule-multiselectDropdown="true">
                                                @if(isset($districts) && !empty($districts))
                                                <option value="all" {{ (request('district1') && in_array('all', request('district1'))) ? 'selected' : '' }}>All</option>
                                                @foreach($districts as $district)
                                                <option value="{{$district->id}}" {{ (request('district1') && in_array($district->id, request('district1'))) ? 'selected' : '' }}>{{$district->district_name}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('district1') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    @else
                                    @if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD'))
                                    <input type="hidden" name="district1" id="district1" value="{{$districts['id']}}">
                                    @error('district1') <span class="text-danger">{{ $message }}</span> @enderror
                                    @endif
                                    @endif
                                    @if($user->hasRole('Admin') || $user->hasRole('Super Admin'))
                                    <div class="col-lg-3 col-md-6 @if(!request('department1'))d-none @endif" data-field="department-1">
                                        <div class="form-group cs-form-group">
                                            <label for="department1" class="form-label">Department <em>*</em></label>
                                            <select name="department1[]" id="department1" class="form-select" multiple data-rule-mandatory="true">
                                                @if(isset($departments) && !empty($departments))
                                                <option value="all">All</option>
                                                @foreach($departments as $department)
                                                <option value="{{$department->id}}" {{ (request('department1') && in_array($department->id, request('department1'))) ? 'selected' : '' }}>{{$department->department_name}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('department1') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    @else
                                    @if($user->hasRole('Department-User') || $user->hasRole('Department-Approver') || $user->hasRole('Department-HOD'))
                                    <input type="hidden" name="department1" id="department1" value="{{$departments['id']}}">
                                    @error('department1') <span class="text-danger">{{ $message }}</span> @enderror
                                    @endif
                                    @endif
                                    <div class="w-100"></div>
                                    <div class="col-md-6">
                                        <div class="form-group cs-form-group mb-0 mt-4">
                                            <div class="form-check-wrapper">
                                                @if($user->hasRole('Admin') || $user->hasRole('Super Admin'))
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="flexRadioDefault1" id="flexRadioDefault1-1" @if(!request('department1') && empty(request('department1')))checked @endif data-radio="district-1" value="district" />
                                                    <label class="form-check-label" for="flexRadioDefault1-1">
                                                        By District <em>*</em>
                                                    </label>
                                                </div>
                                                @else
                                                @if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD'))
                                                <input type="hidden" name="flexRadioDefault1" id="flexRadioDefault1-1" value="district">
                                                @endif
                                                @endif
                                                @if($user->hasRole('Admin') || $user->hasRole('Super Admin'))
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="flexRadioDefault1" id="flexRadioDefault1-2" @if(request('department1') && !empty(request('department1')))checked @endif data-radio="department-1" value="department" />
                                                    <label class="form-check-label" for="flexRadioDefault1-2">
                                                        By Department <em>*</em>
                                                    </label>
                                                </div>
                                                @else
                                                @if($user->hasRole('Department-User') || $user->hasRole('Department-Approver') || $user->hasRole('Department-HOD'))
                                                <input type="hidden" name="flexRadioDefault1" id="flexRadioDefault1-2" value="department">
                                                @endif
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="base" value="financial-year-wise">
                                    <div class="col-md-6">
                                        <div class="mt-3 d-flex justify-content-end">
                                            <button type="submit" id="generate_report_button1" class="btn btn-primary">
                                                Generate Report
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        @if(!empty($financial_year_wise_data) || count($financial_year_wise_data)>0)
                        @if($financial_year_wise_data->total()>0)
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="generated-report-wrapper">
                                    <div class="download-action-tray">
                                        <input type="hidden">
                                        <ul class="text-success download-message" style="display: none;">
                                            <li><b>The Download is in progress, this may take a minute, please wait...!</b></li>
                                        </ul>
                                        <button class="btn btn-danger" id="pdf_button_1">PDF</button>
                                        <button class="btn btn-success" id="excel_button_button_1">Excel</button>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                                            <thead>
                                                <tr>
                                                    <th>Sr No.</th>
                                                    <th>Goal</th>
                                                    <th>Target</th>
                                                    <th>Indicator</th>
                                                    <th>Unit</th>
                                                    <th>Baseline Year</th>
                                                    <th>Baseline Value</th>
                                                    <th>Target 2030</th>
                                                    @if($indicator_type == 'district')
                                                    <th>District</th>
                                                    @else
                                                    <th>Department</th>
                                                    @endif
                                                    <th>Financial Year</th>
                                                    <th>Achieved Value</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($financial_year_wise_data as $data)
                                                <tr>
                                                    <td>{{ ($financial_year_wise_data->currentPage() - 1) * $financial_year_wise_data->perPage() + $loop->iteration }}</td>
                                                    <td>
                                                        Goal {{$data->goal_id}}: {{$data->goal_name}}
                                                    </td>
                                                    <td>
                                                        {{$data->target_name}}
                                                    </td>

                                                    <td>
                                                        {{$data->indicator_name}}
                                                    </td>
                                                    <td>
                                                        {{$data->unit !="" ? $data->unit : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->baseline_year !="" ? $data->baseline_year : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->baseline_value !="" ? $data->baseline_value : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->target_value !="" ? $data->target_value : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        @if($indicator_type == 'district')
                                                        {{$data->district_name != "" ? $data->district_name : 'N/A'}}
                                                        @else
                                                        {{$data->department_name != "" ? $data->department_name : 'N/A'}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        {{$data->reporting_year != "" ? $data->reporting_year : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->achieved_value !="" ? $data->achieved_value : 'N/A'}}
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <nav>
                            <ul class="pagination">
                                {{$financial_year_wise_data->appends(array_merge(request()->query()))->links('pagination.bootstrap-4')}}
                            </ul>
                        </nav>
                        @endif
                        @endif
                    </div>
                    <div class="report-tab-item d-none" data-toggle-tab-content="2">
                        <form id="form2" method="GET" action="{{route('export_report.export_data')}}">
                            <!-- @csrf -->
                            <div class="container-fluid">
                                <div class="row">
                                    @if($user->hasRole('Admin') || $user->hasRole('Super Admin'))
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="department2" class="form-label">Department <em>*</em></label>
                                            <select name="department2" id="department2" class="form-select" data-rule-mandatory="true">
                                                <option value="">-- Select Department --</option>
                                                @if(isset($departments) && !empty($departments))
                                                @foreach($departments as $department)
                                                <option value="{{$department->id}}" {{ (request('department2') && request('department2')==$department->id) ? 'selected' : '' }}>{{$department->department_name}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('department2') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    @else
                                    @if($user->hasRole('Department-User') || $user->hasRole('Department-Approver') || $user->hasRole('Department-HOD'))
                                    <input type="hidden" name="department2" id="department2" value="{{$departments['id']}}">
                                    @error('department2') <span class="text-danger">{{ $message }}</span> @enderror
                                    @endif
                                    @endif
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="goal2" class="form-label">Goal <em>*</em></label>
                                            <select name="goal2[]" id="goal2" class="form-select" multiple data-rule-mandatory="true">
                                                @if(isset($goals) && !empty($goals))
                                                <option value="all" {{ (request('goal2') && in_array('all', request('goal2'))) ? 'selected' : '' }}>All</option>
                                                @foreach($goals as $goal)
                                                <option value="{{$goal['goal_id']}}" {{ (request('goal2') && in_array($goal['goal_id'], request('goal2'))) ? 'selected' : '' }}>{{$goal['goal_name']}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('goal') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="financial_year2" class="form-label">Financial Year <em>*</em></label>
                                            <select name="financial_year2[]" id="financial_year2" class="form-select" multiple data-rule-mandatory="true">
                                                @if(isset($financialYears) && !empty($financialYears))
                                                <option value="all" {{ (request('financial_year2') && in_array('all', request('financial_year2'))) ? 'selected' : '' }}>All</option>
                                                @foreach($financialYears as $financialYear)
                                                <option value="{{$financialYear}}" {{ (request('financial_year2') && in_array($financialYear, request('financial_year2'))) ? 'selected' : '' }}>{{$financialYear}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('financial_year') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    <input type="hidden" name="base" value="department-wise">
                                    <div class="w-100"></div>
                                    <div class="col-12">
                                        <div class="mt-3 d-flex justify-content-end">
                                            <button type="submit" class="btn btn-primary" id="generate_report_button2">
                                                Generate Report
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        @if(!empty($department_wise_data) || count($department_wise_data)>0)
                        @if($department_wise_data->total()>0)
                        <div class="row mt-4" data-report-wrapper="2">
                            <div class="col-12">
                                <div class="generated-report-wrapper">
                                    <div class="download-action-tray">
                                        <button class="btn btn-danger" id="pdf_button_2">PDF</button>
                                        <button class="btn btn-success" id="excel_button_button_2">Excel</button>
                                    </div>
                                    <ul class="text-success download-message" style="display: none;">
                                        <li><b>The Download is in progress, this may take a minute, please wait...!</b></li>
                                    </ul>
                                    <div class="table-responsive">
                                        <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                                            <thead>
                                                <tr>
                                                    <th>Sr No.</th>
                                                    <th>Goal</th>
                                                    <th>Target</th>
                                                    <th>Indicator</th>
                                                    <th>Unit</th>
                                                    <th>Baseline Year</th>
                                                    <th>Baseline Value</th>
                                                    <th>Target 2030</th>
                                                    <th>Department</th>
                                                    <th>Financial Year</th>
                                                    <th>Achieved Value</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($department_wise_data as $data)
                                                <tr>
                                                    <td>{{ ($department_wise_data->currentPage() - 1) * $department_wise_data->perPage() + $loop->iteration }}</td>
                                                    <td>
                                                        Goal {{$data->goal_id}}: {{$data->goal_name}}
                                                    </td>
                                                    <td>
                                                        {{$data->target_name}}
                                                    </td>

                                                    <td>
                                                        {{$data->indicator_name}}
                                                    </td>
                                                    <td>
                                                        {{$data->unit !="" ? $data->unit : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->baseline_year !="" ? $data->baseline_year : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->baseline_value !="" ? $data->baseline_value : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->target_value !="" ? $data->target_value : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->department_name != "" ? $data->department_name : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->reporting_year !="" ? $data->reporting_year : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->achieved_value !="" ? $data->achieved_value : 'N/A'}}
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <nav>
                                <ul class="pagination">
                                    {{$department_wise_data->appends(array_merge(request()->query()))->links('pagination.bootstrap-4')}}
                                </ul>
                            </nav>
                        </div>
                        @endif
                        @endif
                    </div>
                    <div class="report-tab-item d-none" data-toggle-tab-content="3">
                        <form id="form3" method="GET" action="{{route('export_report.export_data')}}">
                            <!-- @csrf -->
                            <div class="container-fluid">
                                <div class="row">
                                    @if($user->hasRole('Admin') || $user->hasRole('Super Admin'))
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="district3" class="form-label">District<em>*</em></label>
                                            <select name="district3" id="district3" class="form-select" data-rule-mandatory="true">
                                                <option value="">--Select District--</option>
                                                @if(isset($districts) && !empty($districts))
                                                @foreach($districts as $district)
                                                <option value="{{$district->id}}" {{ (request('district3') && request('district3')==$district->id) ? 'selected' : '' }}>{{$district->district_name}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('district3') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    @else
                                    @if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD'))
                                    <input type="hidden" name="district3" id="district3" value="{{$districts['id']}}">
                                    @error('district3') <span class="text-danger">{{ $message }}</span> @enderror
                                    @endif
                                    @endif
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="goal3" class="form-label">Goal <em>*</em></label>
                                            <select name="goal3[]" id="goal3" class="form-select" data-rule-mandatory="true" multiple>
                                                @if(isset($goals) && !empty($goals))
                                                <option value="all" {{ (request('goal3') && in_array('all', request('goal3'))) ? 'selected' : '' }}>All</option>
                                                @foreach($goals as $goal)
                                                <option value="{{$goal['goal_id']}}" {{ (request('goal3') && in_array($goal['goal_id'], request('goal3'))) ? 'selected' : '' }}>{{$goal['goal_name']}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('goal3') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="financial_year3" class="form-label">Financial Year <em>*</em></label>
                                            <select name="financial_year3[]" id="financial_year3" class="form-select" multiple data-rule-mandatory="true">
                                                @if(isset($financialYears) && !empty($financialYears))
                                                <option value="all" {{ (request('financial_year3') && in_array('all', request('financial_year3'))) ? 'selected' : '' }}>All</option>
                                                @foreach($financialYears as $financialYear)
                                                <option value="{{$financialYear}}" {{ (request('financial_year3') && in_array($financialYear, request('financial_year3'))) ? 'selected' : '' }}>{{$financialYear}}</option>
                                                @endforeach
                                                @endif
                                            </select>
                                            @error('financial_year3') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    <input type="hidden" name="base" value="district-wise">
                                    <div class="col-12">
                                        <div class="mt-3 d-flex justify-content-end">
                                            <button type="submit" id="generate_report_button3" class="btn btn-primary">
                                                Generate Report
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        @if(!empty($district_wise_data) || count($district_wise_data)>0)
                        @if($district_wise_data->total()>0)
                        <div class="row mt-4" data-report-wrapper="3">
                            <div class="col-12">
                                <div class="generated-report-wrapper">
                                    <div class="download-action-tray">
                                        <button class="btn btn-danger" id="pdf_button_3">PDF</button>
                                        <button class="btn btn-success" id="excel_button_button_3">Excel</button>
                                    </div>
                                    <div class="table-responsive">
                                        <ul class="text-success download-message" style="display: none;">
                                            <li><b>The Download is in progress, this may take a minute, please wait...!</b></li>
                                        </ul>
                                        <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                                            <thead>
                                                <tr>
                                                    <th>Sr No.</th>
                                                    <th>Goal</th>
                                                    <th>Target</th>
                                                    <th>Indicator</th>
                                                    <th>Unit</th>
                                                    <th>Baseline Year</th>
                                                    <th>Baseline Value</th>
                                                    <th>Target 2030</th>
                                                    <th>District</th>
                                                    <th>Financial Year</th>
                                                    <th>Achieved Value</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($district_wise_data as $data)
                                                <tr>
                                                    <td>{{ ($district_wise_data->currentPage() - 1) * $district_wise_data->perPage() + $loop->iteration }}</td>
                                                    <td>
                                                        Goal {{$data->goal_id}}: {{$data->goal_name}}
                                                    </td>
                                                    <td>
                                                        {{$data->target_name}}
                                                    </td>

                                                    <td>
                                                        {{$data->indicator_name}}
                                                    </td>
                                                    <td>
                                                        {{$data->unit !="" ? $data->unit : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->baseline_year !="" ? $data->baseline_year : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->baseline_value !="" ? $data->baseline_value : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->target_value !="" ? $data->target_value : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->district_name != "" ? $data->district_name : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->reporting_year != "" ? $data->reporting_year : 'N/A'}}
                                                    </td>
                                                    <td>
                                                        {{$data->achieved_value !="" ? $data->achieved_value : 'N/A'}}
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <nav>
                                <ul class="pagination">
                                    {{$district_wise_data->appends(array_merge(request()->query()))->links('pagination.bootstrap-4')}}
                                </ul>
                            </nav>
                        </div>
                        @endif
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<script src="{{ asset('assets/js/jquery.js')}}"></script>
<script src="{{ asset('assets/js/jquery.validate.js') }}"></script>
<script src="{{ asset('assets/js/validation.js') }}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>
<script src="{{asset('assets/js/plugins/select2.js')}}"></script>
<!-- Export Report Script -->
<script src="{{asset('assets/js/export-report.js')}}"></script>
<script>
    $(document).ready(function() {

        // Get the current URL and its parameters
        var url = new URL(window.location.href);

        // Remove the 'export' parameter
        url.searchParams.delete('export');

        // Update the browser's URL without reloading the page
        window.history.replaceState({}, '', url.toString());

        <?php if (request('base') == 'financial-year-wise') { ?>
            $('[data-toggle-tab-btn="1"]').trigger('click');
        <?php } else if (request('base') == 'department-wise') { ?>
            $('[data-toggle-tab-btn="2"]').trigger('click');
        <?php } else if (request('base') == 'district-wise') { ?>
            $('[data-toggle-tab-btn="3"]').trigger('click');
        <?php }
        if (request('flexRadioDefault1') == 'district') { ?>
            $('#flexRadioDefault1-1').trigger('click');
        <?php } else if (request('flexRadioDefault1') == 'department') { ?>
            $('#flexRadioDefault1-2').trigger('click');
        <?php } ?>

        //#region Export Report in excel
        $('#excel_button_button_1').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form1').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form1 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'excel';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '{{route("export_report.export_data")}}', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download File button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-primary ms-2">Download file</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });

        $('#excel_button_button_2').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form2').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form2 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'excel';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '{{route("export_report.export_data")}}', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download File button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-primary ms-2">Download file</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });

        $('#excel_button_button_3').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form3').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form3 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'excel';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '{{route("export_report.export_data")}}', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download File button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-primary ms-2">Download file</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });
        //#endregion

        //#region PDF Button Click Event
        $('#pdf_button_1').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form1').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form1 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'pdf';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '{{route("export_report.export_data")}}', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-success ms-2" target="blank" >Open PDF</a><a href="' + response.filepath + '" class="btn btn-primary ms-2" download>Download PDF</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });

        $('#pdf_button_2').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form2').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form2 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'pdf';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '{{route("export_report.export_data")}}', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-success ms-2" target="blank" >Open PDF</a><a href="' + response.filepath + '" class="btn btn-primary ms-2" download>Download PDF</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });

        $('#pdf_button_3').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form3').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form3 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'pdf';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '{{route("export_report.export_data")}}', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-success ms-2" target="blank" >Open PDF</a><a href="' + response.filepath + '" class="btn btn-primary ms-2" download>Download PDF</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });
        //#endregion

        //#region form submission on generate button
        $("#form1").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                form.submit();
            }
        });
        $("#form2").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                form.submit();
            }
        });
        $("#form3").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                form.submit();
            }
        });
        //#endregion
    });
</script>
@endpush