@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - ', 'custom_css' => 'assets/css/department.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
    @if (session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    <div class="card">
        <div class="card-header cs-card-header">
            <h1 class="page-title">Department</h1>
            <div class="card-header-action">
                @can('Export Department')
                <a href="{{url('departments/export')}}" class="btn btn-success btn-sm">
                    Export
                </a>
                @endcan
                @can('Create Department')
                <a href="{{url('departments/create')}}" class="btn btn-primary btn-sm">
                    Add New Department
                </a>
                @endcan
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                    <colgroup>
                        <col style="width: 650px; min-width: 30px" />
                        <col style="width: 120px; min-width: 150px" />
                        <col style="width: 80px; min-width: 100px" />
                    </colgroup>
                    <thead>
                        <tr>
                            <th>Department</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($departments as $department)
                        <tr>
                            <td>
                                {{$department->department_name}}
                            </td>
                            <td><span class="{{$department->status =='Active'?'text-success':'text-danger'}}">{{$department->status =='Active'?'Active':'Inactive'}}</span></td>
                            <td>
                                <a href="{{url('departments/'.$department->id.'/edit')}}" class="cs-icon-edit" data-icon-toggle-title="Edit Department">
                                    <i class="bi bi-pencil-square"></i>
                                </a>
                                @if($department->status == 'Active')
                                <a href="javascript:void(0);" class="cs-icon-delete" data-icon-toggle-title="Discontinue Department" onclick="confirmAction('{{$department->id}}','inactive')">
                                    <i class="bi bi-x-lg" title="Discontinue Department"></i>
                                </a>
                                @else
                                <a href="javascript:void(0);" class="cs-icon-save" data-icon-toggle-title="Activate Department" onclick="confirmAction('{{$department->id}}','active')">
                                    <i class="bi bi-check-lg" title="Activate Department"></i>
                                </a>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <nav>
                <ul class="pagination">
                    {{ $departments->links('pagination.bootstrap-4') }}
                </ul>
            </nav>
        </div>
    </div>
</div>
@endsection
@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>

<script src="{{asset('assets/js/sweetAlert.js')}}"></script>

<script>
    function confirmAction(departmentId, action) {
        var url = 'departments/' + departmentId + '/' + action + '/delete';
        if (action != '') {
            if (action == 'inactive') {
                var prompt = 'Are you sure to discontinue this Department?';
            } else {
                var prompt = 'Are you sure to activate this Department?';
            }
        } else {
            Swal('Error', 'Action not found', 'error');
        }
        Swal.fire({
            title: prompt,
            text: '',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, do it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        })
    }
</script>
@endpush