@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Add Department', 'custom_css' => ''])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
    @if (session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
    @endif
    @if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
        <li>{{$error}}</li>
        @endforeach
    </ul>
    @endif
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Department</h1>
        </div>
        <div class="card-body">
            <form id="create_department" method="POST" action="@if(!empty($departments->id)) {{url('departments/'.$departments->id)}} @else {{ url('departments') }} @endif">
                @csrf
                @if(!empty($departments->id))
                @method('PUT')
                @endif
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <div class="form-group cs-form-group">
                                    <label class="form-label" for="department-name">Department Name <em>*</em></label>
                                    <input type="text" class="form-control" id="department-name" name="department_name" value="@if(!empty($departments) && !empty($departments->department_name)){{$departments->department_name}}@else{{old('department_name')}}@endif" placeholder="Enter Department Name" data-rule-required="true" />
                                </div>
                                @error('department_name') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="w-100"></div>

                        <div class="col-12">
                            <div class="my-4 d-flex justify-content-end">
                                <a href="{{ url()->previous() }}" class="btn btn-danger me-2">Cancel</a>
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@push('script')
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>
<script src="{{asset('assets/js/core/external.min.js')}}"></script>
<script src="{{ asset('assets/js/jquery.js')}}"></script>
<script src="{{ asset('assets/js/jquery.validate.js') }}"></script>
<script src="{{ asset('assets/js/validation.js') }}"></script>
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>
<script>
    $(document).ready(function() {
        $("#create_department").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                // If form is valid, submit the form
                form.submit();
            }
        });
    });
</script>
@endpush