@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Roles', 'custom_css' =>''])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')

<!-- <div class="container mt-5">
    <a href="{{ url('roles') }}" class="btn btn-primary mx-1">Roles</a>
    <a href="{{ url('permissions') }}" class="btn btn-info mx-1">Permissions</a>
    <a href="{{ url('users') }}" class="btn btn-warning mx-1">Users</a>
</div> -->

<div class="page-content">
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Role</h1>
        </div>
        @if (session('status'))
        <div class="alert alert-success">{{ session('status') }}</div>
        @endif
        @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
        @endif
        <div class="card-body">

            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th width="40%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($roles as $role)
                    <tr>
                        <td>{{ $role->id }}</td>
                        <td>{{ $role->name }}</td>
                        <td>
                            <a href="{{ url('roles/'.$role->id.'/give-permissions') }}" class="btn btn-sm btn-success">
                                Add / Edit Role Permission
                            </a>

                            <!-- @can('Update Role')
                                    <a href="{{ url('roles/'.$role->id.'/edit') }}" class="btn btn-sm btn-success">
                                        Edit
                                    </a>
                                    @endcan

                                    @can('Delete Role')
                                    <a href="{{ url('roles/'.$role->id.'/delete') }}" class="btn btn-sm btn-danger mx-2">
                                        Delete
                                    </a>
                                    @endcan -->
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
</div>
@endsection
@push('script')
<!-- Library Bundle Script -->
<script src="assets/js/core/libs.min.js"></script>

<!-- External Library Bundle Script -->
<script src="assets/js/core/external.min.js"></script>

<!-- App Script -->
<script src="assets/js/hope-ui.js" defer></script>
@endpush