@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Permissions', 'custom_css' =>''])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="container mt-5">
    <a href="{{ url('roles') }}" class="btn btn-primary mx-1">Roles</a>
    <a href="{{ url('permissions') }}" class="btn btn-info mx-1">Permissions</a>
    <a href="{{ url('users') }}" class="btn btn-warning mx-1">Users</a>
</div>

<div class="container mt-2">
    <div class="row">
        <div class="col-md-12">

            @if (session('status'))
            <div class="alert alert-success">{{ session('status') }}</div>
            @endif

            <div class="card mt-3">
                <div class="card-header">
                    <h4>Permissions
                        @can('Create Permission')
                        <a href="{{ url('permissions/create') }}" class="btn btn-sm btn-primary float-end">Add Permission</a>
                        @endcan
                    </h4>
                </div>
                <div class="card-body">

                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Name</th>
                                <th width="40%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($permissions as $permission)
                            <tr>
                                <td>{{ $permission->id }}</td>
                                <td>{{ $permission->name }}</td>
                                <td>
                                    @can('Update Permission')
                                    <a href="{{ url('permissions/'.$permission->id.'/edit') }}" class="btn btn-sm btn-success">Edit</a>
                                    @endcan

                                    @can('Delete Permission')
                                    <a href="{{ url('permissions/'.$permission->id.'/delete') }}" class="btn btn-sm btn-danger mx-2">Delete</a>
                                    @endcan
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('script')
<!-- Library Bundle Script -->
<script src="assets/js/core/libs.min.js"></script>

<!-- External Library Bundle Script -->
<script src="assets/js/core/external.min.js"></script>

<!-- App Script -->
<script src="assets/js/hope-ui.js" defer></script>
@endpush