<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class districtIndexes extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Factory::create();
        // Seed data for sdg_index table
        $reporting_years = [
            [
                'year' =>'2011-2012',
                'id' => 1
            ],
            [
                'year' => '2012-2013',
                'id' => 15
            ],
            [
                'year' => '2013-2014',
                'id' => 13
            ],
            [
                'year' => '2014-2015',
                'id' => 11
            ],
            [
                'year' => '2015-2016',
                'id' => 2
            ],
            [
                'year' => '2016-2017',
                'id' => 8
            ],
            [
                'year' => '2017-2018',
                'id' => 9
            ],
            [
                'year' => '2018-2019',
                'id' => 4
            ],
            [
                'year' => '2019-2020',
                'id' => 3
            ],
            [
                'year' => '2020-2021',
                'id' => 5
            ],
            [
                'year' => '2021-2022',
                'id' => 6
            ],
            [
                'year' => '2022-2023',
                'id' => 7
            ],
            [
                'year' => '2023-2024',
                'id' => 10
            ],
            [
                'year' => '2024-2025',
                'id' => 16
            ],
        ];

        foreach ($reporting_years as $year) {
            for ($goalId = 1; $goalId <= 16; $goalId++) {
                for ($districtId = 1; $districtId <= 20; $districtId++) {
                    if ($goalId == 14) continue;
                    DB::table('district_sdg_indexes')->insert([
                        'district_id' => $districtId,
                        'goal_id' => $goalId,
                        'score' => $faker->randomFloat(2, 0, 100),
                        'reporting_year_id' => $year['id'],
                        'reporting_year' => $year['year'],
                    ]);
                }
            }
        }
    }
}
