<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TargetSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $goalsAndTargets = [
            '1' => [
                '1.1 By 2030, eradicate extreme poverty for all people everywhere, currently measured as people living on less than $1.25 a day.',
                '1.3 Implement nationally appropriate social protection systems and measures for all, including floors, and by 2030 achieve substantial coverage of the poor and the vulnerable',
                '1.4 By 2030, ensure that all men and women, in particular the poor and the vulnerable, have equal rights to economic resources, as well as access to basic services, ownership and control over land and other forms of property, inheritance, natural resources, appropriate new technology and financial services, including microfinance'
            ],
            '2' => [
                '2.1 By 2030, end hunger and ensure access by all people, in particular the poor and people in vulnerable situations, including infants, to safe, nutritious and sufficient food all year round',
                '2.2 By 2030, end all forms of malnutrition, including achieving, by 2025, the internationally agreed targets on stunting and wasting in children under 5 years of age, and address the nutritional needs of adolescent girls, pregnant and lactating women and older persons',
                '2.3 By 2030, double the agricultural productivity and incomes of small-scale food producers, in particular women, indigenous peoples, family farmers, pastoralists and fishers, including through secure and equal access to land, other productive resources and inputs, knowledge, financial services, markets and opportunities for value addition and non-farm employment',
                '2.4 By 2030 ensure sustainable food production systems and implement resilient agricultural practices that increase productivity and production, that help maintain ecosystems, that strengthen capacity for adaptation to climate change, extreme weather, drought, flooding and other disasters, and that progressively improve land and soil quality'
            ],
            '3' =>      [
                '3.1 By 2030, reduce the global maternal mortality ratio to less than 70 per 1,00,000 live births',
                '3.2 By 2030, end preventable deaths of newborns and children under 5 years of age, with all countries aiming to reduce neonatal mortality to at least as low as 12 per 1,000 live births and under-5 mortality to at least as low as 25 per 1,000 live births',
                '3.3 By 2030, end the epidemics of AIDS, tuberculosis, malaria and neglected tropical diseases and combat hepatitis, waterborne diseases and other communicable diseases',
                '3.4 By 2030, reduce by one third premature mortality from non-communicable diseases through prevention and treatment and promote mental health and well-being',
                '3.5 Strengthen the prevention and treatment of substance abuse, including narcotic drug abuse and harmful use of alcohol',
                '3.6 By 2020, halve the number of global deaths and injuries from road traffic accidents',
                '3.7 By 2030, ensure universal access to sexual and reproductive health-care services, including forfamily planning, information and education, and the integration of reproductive health into nationalstrategies and programmes',
                '3.8 Achieve universal health coverage, including financial risk protection, access to quality essential health-care services and access to safe, effective, quality and affordable essential medicines and vaccines for all',
                '3.c Substantially increase health financing and the recruitment, development, training and retention ofthe health workforce in developing countries, especially in least developed countries and small island developing States'
            ],
            '4' => [
                '4.1 By 2030, ensure that all girls and boys complete free, equitable and quality primary and secondary education leading to relevant and effective learning outcomes',
                '4.5 By 2030, eliminate gender disparities in education and ensure equal access to all levels of education and vocational training for the vulnerable, including persons with disabilities, indigenous peoples and children in vulnerable situations',
                '4.a Build and upgrade education facilities that are child, disability and gender sensitive and provide safe, non-violent, inclusive and effective learning environments for all',
                '4.c By 2030, substantially increase the supply of qualified teachers, including through international cooperation for teacher training in developing countries, especially least developed countries and small island developing States',

            ],
            '5' => [
                '5.1 End all forms of discrimination against all women and girls everywhere',
                '5.2 Eliminate all forms of violence against all women and girls in the public and private spheres, including trafficking and sexual and other types of exploitation',
                '5.3 Eliminate all harmful practices, such as child, early and forced marriage and female genital mutilation',
                '5.5 Ensure women’s full and effective participation and equal opportunities for leadership at all levels of decision-making in political, economic and public life',
                '5.a Undertake reforms to give women equal rights to economic resources, as well as access to ownership and control over land and other forms of property, financial services, inheritance and naturalresources, in accordance with national laws'
            ],
            '6' => [
                '6.1 By 2030, achieve universal and equitable access to safe and affordable drinking water for all',
                '6.2 By 2030, achieve access to adequate and equitable sanitation and hygiene for all and end open defecation, paying special attention to the needs of women and girls and those in vulnerable situations',
                '6.3 By 2030, improve water quality by reducing pollution, eliminating dumping and minimizing release of hazardous chemicals and materials, halving the proportion of untreated wastewater and substantially increasing recycling and safe reuse globally',
                '6.b Support and strengthen the participation of local communities in improving water and sanitation management'
            ],
            '7' => [
                '7.1 By 2030, ensure universal access to affordable, reliable and modern Energy Services',
                '7.2 By 2030, increase substantially the share of renewable energy in the global energy mix'
            ],
            '8' => [
                '8.3 Promote development-oriented policies that support productive activities, decent job creation, entrepreneurship, creativity and innovation, and encourage the formalization and growth of micro-, small- and medium-sized enterprises, including through access to financial services',
                '8.4 Improve progressively, through 2030, global resource efficiency in consumption and production and endeavour to decouple economic growth from environmental degradation, in accordance with the 10-Year Framework of Programmes on Sustainable Consumption and Production, with developed countries taking the lead',
                '8.6 By 2030, substantially reduce the proportion of youth not in employment, education or training',
                '8.7 Take immediate and effective measures to eradicate forced labour, end modern slavery and humantrafficking and secure the prohibition and elimination of the worst forms of child labour, including recruitment and use of child soldiers, and by 2025 end child labour in all its forms',
                '8.8 Protect labour rights and promote safe and secure working environments for all workers, including migrant workers, in particular women migrants, and those in precarious employment',
                '8.10 Strengthen the capacity of domestic financial institutions to encourage and expand access to banking, insurance and financial services for all'
            ],
            '9' => [
                '9.1 Develop quality, reliable, sustainable and resilient infrastructure, including regional and trans-border infrastructure, to support economic development and human well-being, with a focus on affordable and equitable access for all',
                '9.c. Significantly increase access to information and communications technology and strive to provide universal and affordable access to the Internet in least developed countries by 2020'
            ],
            '10' => [
                '10.2 By 2030, empower and promote the social, economic and political inclusion of all, irrespective of age, sex, disability, race, ethnicity, origin, religion or economic or other status',
                '10.4 Adopt policies, especially fiscal, wage and social protection policies, and progressively achieve greater equality'
            ],
            '11' => [
                '11.1 By 2030, ensure access for all to adequate, safe and affordable housing and basic services and upgrade slums',
                '11.2 By 2030, provide access to safe, affordable, accessible and sustainable transport systems for all, improving road safety, notably by expanding public transport, with special attention to the needs of those in vulnerable situations, women, children, persons with disabilities and older persons',
                '11.4 Strengthen efforts to protect and safeguard the world’s cultural and natural heritage',
                '11.5 By 2030, significantly reduce the number of deaths and the number of people affected and substantially decrease the direct economic losses relative to global gross domestic product caused by disasters, including water-related disasters, with a focus on protecting the poor and people in vulnerable situations',
                '11.6 By 2030, reduce the adverse per capita environmental impact of cities, including by paying special attention to air quality and municipal and other waste management'
            ],
            '12' => [
                '12.2 By 2030, achieve the sustainable management and efficient use of natural resources',
                '12.3 By 2030, halve per capita global food waste at the retail and consumer levels and reduce food losses along production and supply chains, including post-harvest losses',
                '12.5 By 2030, substantially reduce waste generation through prevention, reduction, recycling and reuse'
            ],
            '13' => [
                '13.1 Strengthen resilience and adaptive capacity to climate-related hazards and natural disasters in all countries'
            ],
            '14' => [
                '15.1 By 2020, ensure the conservation, restoration and sustainable use of terrestrial and inland freshwater ecosystems and their services, in particular forests, wetlands, mountains and drylands, in line with obligations under international agreements',
                '15.2 By 2020, promote the implementation of sustainable management of all types of forests, halt deforestation, restore degraded forests and substantially increase afforestation and reforestation globally',
                '15.4 By 2030, ensure the conservation of mountain ecosystems, including their biodiversity, in order to enhance their capacity to provide benefits that are essential for sustainable development',
                '15.7 Take urgent action to end poaching and trafficking of protected species of flora and fauna and address both demand and supply of illegal wildlife products'
            ],
            '15' => [
                '16.1 Significantly reduce all forms of violence and related death rates everywhere',
                '16.2 End abuse, exploitation, trafficking and all forms of violence against and torture of children',
                '16.3 Promote the rule of law at the national and international levels and ensure equal access to justice for all',
                '16.4 By 2030, significantly reduce illicit financial and arms flows, strengthen the recovery and return of stolen assets and combat all forms of organized crime',
                '16.5 Substantially reduce corruption and bribery in all their forms',
                '16.6 Develop effective, accountable and transparent institutions at all levels',
                '16.7 Ensure responsive, inclusive, participatory and representative decision-making at all levels',
                '16.9 By 2030, provide legal identity for all, including birth registration',
                '16.10 Ensure public access to information and protect fundamental freedoms, in accordance with national legislation and international agreements'
            ]
        ];

        foreach ($goalsAndTargets as $goalID => $targets) {

            foreach ($targets as $target) {
                DB::table('targets')->insert([
                    'goal_id' => $goalID,
                    'target_name' => $target,
                    'status' => 'active', // or 'inactive', depending on your needs
                    'date_added' => now(),
                    'date_updated' => now(),
                ]);
            }
        }
    }
}
