<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory;

class IndicatorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Factory::create();

        $indicatorNames = [
            'Proportion of population below the international poverty line',
            'Prevalence of undernourishment among children under 5 years of age',
            'Percentage of births attended by skilled health personnel',
            'Net enrollment ratio in primary education',
            'Ratio of female to male labor force participation rate',
            'Proportion of population using safely managed drinking water services',
            'Share of renewable energy in the total final energy consumption',
            'Unemployment rate',
            'Research and development expenditure as a proportion of GDP',
            'Gini coefficient of income distribution',
            'Proportion of urban population living in slums',
            'Per capita material footprint of consumption',
            'CO2 emissions per capita',
            'Marine protected areas as a percentage of territorial waters',
            'Forest area as a percentage of total land area',
            'Number of victims of intentional homicide per 100,000 population',
            'Total official development assistance (ODA) as a percentage of gross national income (GNI)',
            'Proportion of population below the international poverty line',
            'Prevalence of undernourishment among children under 5 years of age',
            'Percentage of births attended by skilled health personnel',
            'Net enrollment ratio in primary education',
            'Ratio of female to male labor force participation rate',
            'Proportion of population using safely managed drinking water services',
            'Share of renewable energy in the total final energy consumption',
            'Unemployment rate',
            'Research and development expenditure as a proportion of GDP',
            'Gini coefficient of income distribution',
            'Proportion of urban population living in slums',
            'Per capita material footprint of consumption',
            'CO2 emissions per capita',
            'Marine protected areas as a percentage of territorial waters',
            'Forest area as a percentage of total land area',
            'Number of victims of intentional homicide per 100,000 population',
            'Total official development assistance (ODA) as a percentage of gross national income (GNI)',
            'Proportion of population below the international poverty line',
            'Prevalence of undernourishment among children under 5 years of age',
            'Percentage of births attended by skilled health personnel',
            'Net enrollment ratio in primary education',
            'Ratio of female to male labor force participation rate',
            'Proportion of population using safely managed drinking water services',
            'Share of renewable energy in the total final energy consumption',
            'Unemployment rate',
            'Research and development expenditure as a proportion of GDP',
            'Gini coefficient of income distribution',
            'Proportion of urban population living in slums',
            'Per capita material footprint of consumption',
            'CO2 emissions per capita',
            'Marine protected areas as a percentage of territorial waters',
            'Forest area as a percentage of total land area',
            'Number of victims of intentional homicide per 100,000 population',
            'Total official development assistance (ODA) as a percentage of gross national income (GNI)'
        ];

        foreach($indicatorNames as $indicatorName) {
            DB::table('indicators')->insert([
                'indicator_number'=>'IND-'.rand(1000, 9999),
                'indicator_name' => $indicatorName,
                'unit' => $faker->randomElement(['Percentage', 'Absolute', 'Ratio']),
                'department_id' => rand(1, 20), 
                'scheme_id' => rand(1, 51),
                'target_id' => rand(1, 39),
                'goal_id' => rand(1, 13),
                'is_positive_indicator' => $faker->randomElement(['Positive', 'Negative']),
                'is_utif' => $faker->randomElement(['Yes', 'No']),
                'is_dif' => $faker->randomElement(['Yes', 'No']),
                'status' => 'active', 
                'date_added' => now(),
                'date_updated' => now(),
            ]);
        }
    }
}
