<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Nette\Utils\Random;
use Faker\Factory;

class DistrictSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Factory::create();

        $statesAndDistricts = [
            'Jammu and Kashmir' => ['Anantnag', 'Bandipora', 'Baramulla', 'Budgam', 'Doda', 'Ganderbal', 'Jammu', 'Kathua', 'Kishtwar', 'Kulgam', 'Kupwara', 'Poonch', 'Pulwama', 'Rajouri', 'Ramban', 'Reasi', 'Samba', 'Shopian', 'Srinagar', 'Udhampur']
        ];

        $regions = ['Jammu', 'Kashmir'];

        foreach ($statesAndDistricts as $stateName => $districts) {
            // Fetch the id of the state
            $stateId = DB::table('states')->where('state_name', $stateName)->value('state_id');

            foreach ($districts as $district) {
                DB::table('districts')->insert([
                    'state_id' => $stateId,
                    'district_name' => $district,
                    'region' => $faker->randomElement($regions), 
                    'status' => 'active', 
                    'date_added' => now(),
                    'date_updated' => now()
                ]);
            }
        }
    }
}
