<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DepartmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $departments = [
            "Agriculture Production and Farmers Welfare Department",
            "Department of Culture",
            "Department of Disaster Management, Relief, Rehabilitation & Reconstruction",
            "Department of Food, Civil Supplies and Consumer Affairs",
            "Department of Health and Medical Education",
            "Department of Higher Education",
            "Department of Horticulture",
            "Department of Law, Justice and Parliamentary Affairs",
            "Department of RD PR",
            "Department of Science and Technology",
            "Department of Social Welfare",
            "Directorate of Economics and Statistics",
            "Directorate of Tourism Jammu",
            "Finance Department",
            "Forest Department",
            "Home Department",
            "Housing and Urban Development Department",
            "Industry and Commerce Department",
            "Information Technology Department",
            "Jal Shakti Department",
            "Labour & Employment Department",
            "Office of Chief Electoral Officer",
            "Planning Development & Monitoring Department",
            "Pollution Control Committee",
            "Power Development Department",
            "PWD (R&B)",
            "School Education Department",
            "Transport Department",
            "Tribal Affairs Department"
        ];
        foreach ($departments as $department) {
            DB::table('departments')->insert([
                'department_name' => $department,
                'status' => 'active', // or 'inactive', depending on your needs
                'date_added' => now(),
                'date_updated' => now(),
            ]);
        }
    }
}
