<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class UpdateStatusColumnInIndicatorDataEntries extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Run raw SQL query to alter the 'status' column
        DB::statement("
            ALTER TABLE `indicator_data_entries`
            CHANGE `status` `status` enum('Pending','Approved','Disapproved','Sent_to_approver','Sent_for_level_one_approval','Sent_for_hod_approval','Sent_for_admin_approval') 
            COLLATE 'utf8mb4_unicode_ci' NOT NULL DEFAULT 'Pending' 
            AFTER `indicator_value_comment`;
        ");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Revert to the original enum values
        DB::statement("
            ALTER TABLE `indicator_data_entries`
            CHANGE `status` `status` enum('Pending','Sent_to_approver','Approved','Disapproved') 
            COLLATE 'utf8mb4_unicode_ci' NOT NULL DEFAULT 'Pending' 
            AFTER `indicator_value_comment`;
        ");
    }
}
