<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMultiLevelApprovalsToIndicatorDataEntries extends Migration
{
    public function up(): void
    {
        Schema::table('indicator_data_entries', function (Blueprint $table) {
            // Level One Approver
            $table->unsignedBigInteger('level_one_approver_id')->nullable()->after('reporter_name');
            $table->enum('level_one_approval_status', ['Pending', 'Approved', 'Rejected'])->default('Pending')->after('level_one_approver_id');
            $table->date('level_one_approval_date')->nullable()->after('level_one_approval_status');

            // Level two Approver
            $table->unsignedBigInteger('level_two_approver_id')->nullable()->after('level_one_approval_date');
            $table->enum('level_two_approval_status', ['Pending', 'Approved', 'Rejected'])->default('Pending')->after('level_two_approver_id');
            $table->date('level_two_approval_date')->nullable()->after('level_two_approval_status');

            // Level Three Approver
            $table->unsignedBigInteger('level_three_approver_id')->nullable()->after('level_two_approval_date');
            $table->enum('level_three_approval_status', ['Pending', 'Approved', 'Rejected'])->default('Pending')->after('level_three_approver_id');
            $table->date('level_three_approval_date')->nullable()->after('level_three_approval_status');

            // Adding the data_added_by column to store the user ID
            $table->unsignedBigInteger('data_added_by')->nullable()->after('disapproval_date');
            
            // Adding a foreign key constraint to reference the users table
            $table->foreign('data_added_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('indicator_data_entries', function (Blueprint $table) {
            // Drop foreign key constraint first
            $table->dropForeign(['data_added_by']);
            $table->dropColumn([
                'level_one_approver_id', 'level_one_approval_status', 'level_one_approval_date',
                'level_two_approver_id', 'level_two_approval_status', 'level_two_approval_date',
                'level_three_approver_id', 'level_three_approval_status', 'level_three_approval_date',
                'data_added_by'
            ]);
        });
    }
}
