<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class UpdateReportingYearBaseColumn extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Fetch all records from reporting_years table and update the reporting_year_base column
        $reportingYears = DB::table('reporting_years')->get();

        foreach ($reportingYears as $year) {
            // Extract the first part of reporting_year (e.g., "2022-2023" -> 2022)
            $baseYear = explode('-', $year->reporting_year)[0];

            // Update the reporting_year_base column
            DB::table('reporting_years')
                ->where('id', $year->id)
                ->update(['reporting_year_base' => $baseYear]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Optionally, you can reset the reporting_year_base column if necessary
        DB::table('reporting_years')->update(['reporting_year_base' => null]);
    }
}
