<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGoalComparisionWithIndiaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('goal_comparision_with_india', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();
            $table->unsignedBigInteger('goal_id')->nullable()->comment('Nullable for composite scores');
            $table->integer('india_score')->comment('Score of India for the goal');
            $table->unsignedBigInteger('best_performer_state')->comment('ID of the state which is the best performer of that year');
            $table->integer('best_performer_state_score');
            $table->unsignedBigInteger('best_performer_ut');
            $table->unsignedInteger('best_performer_ut_score');
            $table->integer('jammu_and_kashmir_score')->nullable()->comment('Score of Mizoram');
            $table->enum('jammu_and_kashmir_category', ['Achiever', 'Front Runner', 'Performer', 'Aspirant', 'Information Unavailable'])
                  ->default('Achiever')
                  ->comment('Category based on Mizoram score');
            $table->string('reporting_year', 10)->comment('Year for which this score is valid');
            $table->unsignedBigInteger('reporting_year_id');
            $table->timestamp('date_added')->useCurrent();
            $table->timestamp('date_updated')->useCurrent()->useCurrentOnUpdate();
            $table->unique(['goal_id', 'reporting_year_id'], 'goal_year_unique');
            $table->foreign('reporting_year_id')
                  ->references('id')
                  ->on('reporting_years')
                  ->onUpdate('cascade');
            $table->foreign('goal_id')
                  ->references('id')
                  ->on('goals')
                  ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('goal_comparision_with_india');
    }
}
