<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('indicator_data_entries', function (Blueprint $table) {
            // Add the new column after 'indicator_normalised_value'
            $table->string('indicator_value_comment', 555)
                ->collation('utf8mb4_unicode_ci')
                ->nullable()
                ->after('indicator_normalised_value');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('indicator_data_entries', function (Blueprint $table) {
            // Drop the column if the migration is rolled back
            $table->dropColumn('indicator_value_comment');
        });
    }
};
