<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::unprepared("
        DROP PROCEDURE IF EXISTS `setDistrictsRanks`;
        CREATE PROCEDURE `setDistrictsRanks`(IN `p_reporting_year_id` int(10))
        BEGIN
            -- Declare rank variables
            DECLARE done INT DEFAULT 0;
            DECLARE rrank INT DEFAULT 0;
            DECLARE prev_score DECIMAL(10,2) DEFAULT NULL;
            DECLARE n_district_id INT;
            DECLARE n_score DECIMAL(10,2);

            -- Create a cursor for selecting the district_id and score
            DECLARE cur CURSOR FOR 
                SELECT district_id, score
                FROM district_indexes
                WHERE reporting_year_id = p_reporting_year_id
                ORDER BY score DESC;

            -- Declare a handler for when the cursor has no more rows
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = 1;

            -- Open the cursor
            OPEN cur;

            -- Start a loop to go through the results and update ranks
            read_loop: LOOP
                FETCH cur INTO n_district_id, n_score;
                IF done THEN
                    LEAVE read_loop;
                END IF;

                -- Update the rank based on score comparison
                IF prev_score IS NULL OR prev_score != n_score THEN
                    SET rrank = rrank + 1;
                END IF;

                -- Update district_indexes with the new rank
                UPDATE district_indexes
                SET `rank` = rrank
                WHERE district_id = n_district_id AND reporting_year_id = p_reporting_year_id;

                -- Update the previous score to the current score
                SET prev_score = n_score;
            END LOOP;

            -- Close the cursor
            CLOSE cur;

            -- Update ranks in the districts table
            UPDATE districts AS d
            JOIN (
                SELECT 
                    district_id,
                    `rank`
                FROM 
                    district_indexes
                WHERE 
                    reporting_year_id = p_reporting_year_id
                ORDER BY 
                    score DESC
            ) AS temp ON d.id = temp.district_id
            SET d.rank = temp.rank;
        END;");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::unprepared('DROP PROCEDURE IF EXISTS `setDistrictsRanks`');
    }
};
