<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->bigInteger('district_id')->unsigned()->nullable()->after('password');
            $table->bigInteger('department_id')->unsigned()->nullable()->after('district_id');

            $table->foreign('district_id')->references('id')->on('districts')->onDelete('restrict');
            $table->foreign('department_id')->references('id')->on('departments')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['district_id']);
            $table->dropForeign(['department_id']);

            $table->dropColumn('district_id');
            $table->dropColumn('department_id');
        });
    }
};
