<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('district_indexes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('district_id');
            $table->integer('score')->default(0);
            $table->unsignedBigInteger('reporting_year_id');
            $table->string('reporting_year',10);
            $table->dateTime('date_added')->default(now()); // Default current timestamp
            $table->dateTime('date_updated')->nullable();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('district_indexes');
    }
};
