<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('indicator_update_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('indicator_data_entries_id');
            $table->foreign('indicator_data_entries_id')->references('id')->on('indicator_data_entries');
            $table->Integer('update_count')->default(0);
            $table->string('last_updated_by')->nullable();
            $table->timestamps();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('indicator_update_histories');
    }
};
