<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::unprepared("
        DROP PROCEDURE IF EXISTS `calculateNormalizedValuePositiveIndicator`;
        CREATE PROCEDURE `calculateNormalizedValuePositiveIndicator`(IN `p_indicator_id` int, IN `p_district_id` int, IN `p_reporting_year_id` int)
        BEGIN
            DECLARE minindicatorvalue DECIMAL(10,2);
            DECLARE indicatorvalue DECIMAL(10,2);
            DECLARE targetvalue DECIMAL(10,2);
            DECLARE calculatednormalizedvalue DECIMAL(10,2);

            
            SELECT MIN(indicator_value)
            INTO minindicatorvalue
            FROM indicator_data_entries
            WHERE indicator_id = p_indicator_id
            AND reporting_year_id = p_reporting_year_id AND unit != 'Absolute' AND status = 'Approved';

            
            SELECT indicator_value, target_value
            INTO indicatorvalue, targetvalue
            FROM indicator_data_entries
            WHERE indicator_id = p_indicator_id
            AND district_id = p_district_id
            AND reporting_year_id = p_reporting_year_id AND unit != 'Absolute' AND status = 'Approved';

            
            SET calculatednormalizedvalue = ((indicatorvalue - minindicatorvalue) / (targetvalue - minindicatorvalue)) * 100;
        SELECT 'calculatednormalizedvalue: ', calculatednormalizedvalue;
            
            IF calculatednormalizedvalue < 0 THEN
                SET calculatednormalizedvalue = 0;
            ELSEIF calculatednormalizedvalue > 100 THEN
                SET calculatednormalizedvalue = 100;
            END IF;

            
            UPDATE indicator_data_entries
            SET indicator_normalised_value = ROUND(calculatednormalizedvalue)
            WHERE indicator_id = p_indicator_id
            AND district_id = p_district_id
            AND reporting_year_id = p_reporting_year_id AND unit != 'Absolute' AND status = 'Approved';
        END;
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::unprepared('DROP PROCEDURE IF EXISTS `calculateNormalizedValuePositiveIndicator`;');
    }
};
