<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::unprepared('
        DROP PROCEDURE IF EXISTS `calculateDistrictScore`;
        CREATE PROCEDURE `calculateDistrictScore`(IN `p_district_id` int, IN `p_reporting_year_id` int)
        BEGIN
            DECLARE reportingyear VARCHAR(10);
            DECLARE districtscorevalue INT;
            DECLARE districtscorecount INT;
            DECLARE calculatedarithmeticvalue INT;

            
            SELECT reporting_year
            INTO reportingyear
            FROM reporting_years
            WHERE id = p_reporting_year_id;

            
            SELECT SUM(score)
            INTO districtscorevalue
            FROM district_sdg_indexes
            WHERE district_id = p_district_id
            AND reporting_year_id = p_reporting_year_id;

            
            SELECT COUNT(score)
            INTO districtscorecount
            FROM district_sdg_indexes
            WHERE district_id = p_district_id
            AND reporting_year_id = p_reporting_year_id;

            
            SET calculatedarithmeticvalue = ROUND(districtscorevalue / districtscorecount);

            
            INSERT INTO district_indexes(district_id, score, reporting_year_id, reporting_year, date_added, date_updated)
        VALUES (p_district_id, calculatedarithmeticvalue, p_reporting_year_id, reportingyear, NOW(), NOW())
        ON DUPLICATE KEY UPDATE
            score = calculatedarithmeticvalue,
            date_updated = NOW();


        END;
        ');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::unprepared('DROP PROCEDURE IF EXISTS `calculateDistrictScore`');
    }
};
