<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sdg_score_categorization', function (Blueprint $table) {
            $table->id();
            $table->string('name', 55);
            $table->unsignedSmallInteger('min_value');
            $table->unsignedSmallInteger('max_value');
            $table->string('color_code', 50);
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sdg_score_categorization');
    }
};
