<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('indicators', function (Blueprint $table) {
            // Change department_id column to allow NULL
            $table->unsignedBigInteger('department_id')->nullable()->change();

            // Add baseline_year_id and baseline_year columns
            $table->unsignedBigInteger('baseline_year_id')->after('is_dif')->nullable();
            $table->string('baseline_year', 10)->collation('utf8_unicode_ci')->after('baseline_year_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('indicators', function (Blueprint $table) {
            $table->dropColumn('baseline_year');
            $table->dropColumn('baseline_year_id');
            $table->unsignedBigInteger('department_id')->change();
        });
    }
};
