<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('indicators_to_districts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('indicator_id');
            $table->unsignedBigInteger('district_id');
            $table->unsignedBigInteger('reporter_id')->comment('User ID who enter the data for the mapped indicator');
            $table->unsignedBigInteger('approver_id')->comment('User ID who approve the data entered for the associated indicator');
            $table->engine = 'InnoDB';
            // Foreign key constraints
            $table->foreign('indicator_id')->references('id')->on('indicators');
            $table->foreign('district_id')->references('id')->on('districts');
            // Assuming reporter_id and approver_id are foreign keys referencing a users table, adjust accordingly
            $table->foreign('reporter_id')->references('id')->on('users');
            $table->foreign('approver_id')->references('id')->on('users');
            // Ensure uniqueness of indicator_id and district_id combination
            $table->unique(['indicator_id', 'district_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('indicators_to_districts');
    }
};
