<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('district_sdg_indexes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('district_id');
            $table->unsignedBigInteger('goal_id');
            $table->integer('score')->default(0);
            $table->unsignedBigInteger('reporting_year_id');
            $table->string('reporting_year', 10);
            $table->dateTime('date_added')->default(now());
            $table->dateTime('date_updated')->nullable();
            $table->engine = 'InnoDB';
            // Foreign key constraints
            $table->foreign('district_id')->references('id')->on('districts');
            $table->foreign('goal_id')->references('id')->on('goals');
            $table->foreign('reporting_year_id')->references('id')->on('reporting_years');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('district_sdg_indexes');
    }
};
