<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reporting_years', function (Blueprint $table) {
            $table->id();
            $table->string('reporting_year', 10);
            $table->enum('is_default', ['No', 'Yes'])->default('No');
            $table->enum('status', ['Inactive', 'Active'])->default('Active');
            $table->dateTime('date_added')->default(now());
            $table->dateTime('date_updated')->nullable();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reporting_years');
    }
};
