<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('districts', function (Blueprint $table) {
            $table->id();
            $table->string('district_name');
            $table->enum('region', ['Jammu', 'Kashmir'])->default('Jammu');
            $table->enum('status', ['Inactive', 'Active'])->default('Active');
            $table->dateTime('date_added')->default(now());
            $table->dateTime('date_updated')->nullable();
            $table->unsignedBigInteger('state_id');
            $table->engine = 'InnoDB';
            $table->foreign('state_id')->references('state_id')->on('states');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('districts');
    }
};
