<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('targets', function (Blueprint $table) {
            $table->id('target_id');
            $table->string('target_number',20);
            $table->string('target_name',1000);
            $table->enum('status', ['Inactive', 'Active'])->default('Active');
            $table->enum('target_type', ['dif','utif','both'])->default('dif');
            $table->dateTime('date_added')->default(now());
            $table->dateTime('date_updated')->nullable();
            $table->unsignedBigInteger('goal_id');
            $table->engine = 'InnoDB';
            $table->foreign('goal_id')->references('id')->on('goals');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('targets');
    }
};
