// BOC
// Task #156544 The Comparison on SDG India Index section should display a detailed comparison of SDG scores with other states.
// This js file is used to render the Admin page input for the comparsion of India with SDG.
// @author Almaaz Ahmed
// @date 18-12-2024
$(document).ready(function () {
    $("[data-tab]").click(function () {
        const target = $(this).attr("data-tab");
        $("[data-tab]").removeClass("btn-primary");
        $("[data-tab]").addClass("btn-muted");
        $(this).addClass("btn-primary");
        $(this).removeClass("btn-muted");

        $("[data-tab-content]").addClass("d-none");
        $(`[data-tab-content="${target}"]`).removeClass("d-none");
    });

    /**
     * Function to handle the click events on the goals
     */
    $("[data-mc-goal]").click(function () {
        var TITLES = {};

        // Check if `allGoals` is defined and has valid data
        if (typeof allGoals !== 'undefined' && Array.isArray(allGoals) && allGoals.length > 0) {
            TITLES = allGoals.reduce((acc, goal) => {
                acc[`mc-${goal.id}`] = `${goal.id}. ${goal.goal_name}`;
                return acc;
            }, { "mc-all": "Composite Score" });
        } else {
            // Static fallback titles
            TITLES = {
                "mc-1": "Goal Name Not Found",
            };
        }

        const target = $(this).attr("data-mc-goal");
        // Remove "mc-" prefix
        const goalId = target.replace("mc-", "");

        // Set hidden field value
        $("#goal_id").val(goalId);

        $("[data-mc-goal]").each(function () {
            $(this).removeClass("active");
        });
        $(this).addClass("active");
        $("[data-mc-header]").attr("data-mc-header", target);
        $("[data-mc-header] .mc-header-left").html(TITLES[target]);
        if (target != "mc-14" && target != "mc-17") {
            let year = $("[data-goal-year]").val();
            fetchGoalData(target, year);
            $(`[data-wrapper="graph"]`).removeClass("d-none");
            $(`[data-wrapper="mc-14"]`).addClass("d-none");
            $(`[data-wrapper="mc-17"]`).addClass("d-none");
            $(`[data-form="1"]`).attr("disabled", false);
        } else {
            if (target === "mc-14") {
                $(`[data-wrapper="graph"]`).addClass("d-none");
                $(`[data-wrapper="mc-14"]`).removeClass("d-none");
                $(`[data-wrapper="mc-17"]`).addClass("d-none");
                $(`[data-form="1"]`).attr("disabled", true);
            } else if (target === "mc-17") {
                $(`[data-wrapper="graph"]`).addClass("d-none");
                $(`[data-wrapper="mc-14"]`).addClass("d-none");
                $(`[data-wrapper="mc-17"]`).removeClass("d-none");
                $(`[data-form="1"]`).attr("disabled", true);
            }
        }
    });

    $("[data-goal-year]").change(function () {
        let year = $(this).val();
        let goal = $("[data-mc-goal].active").attr("data-mc-goal");
        if (goal != "mc-14" && goal != "mc-17") {
            fetchGoalData(goal, year);
            $(`[data-wrapper="graph"]`).removeClass("d-none");
            $(`[data-wrapper="mc-14"]`).addClass("d-none");
            $(`[data-wrapper="mc-17"]`).addClass("d-none");
            $(`[data-form="1"]`).attr("disabled", false);
        } else {
            if (goal === "mc-14") {
                $(`[data-wrapper="graph"]`).addClass("d-none");
                $(`[data-wrapper="mc-14"]`).removeClass("d-none");
                $(`[data-wrapper="mc-17"]`).addClass("d-none");
                $(`[data-form="1"]`).attr("disabled", true);
            } else if (goal === "mc-17") {
                $(`[data-wrapper="graph"]`).addClass("d-none");
                $(`[data-wrapper="mc-14"]`).addClass("d-none");
                $(`[data-wrapper="mc-17"]`).removeClass("d-none");
                $(`[data-form="1"]`).attr("disabled", true);
            }
        }
    });
    
    function fetchGoalData(goal, year) {
        if (year != "" && goal != "") {
            $.ajax({
                url: comparisionDataUrl,
                method: "GET",
                data: { goal: goal, year: year },
                success: function (data) {
                    // Reset fields to default values
                    $("#india_score").val(0);
                    $("#bestPerformingState").val("");
                    $("#best_state_score").val(0);
                    $("#best_state_score")
                        .closest(".form-group")
                        .addClass("d-none");
                    $("#jammu_and_kashmir_score").val(0); // Assuming 30 is the default score

                    if (data.values.length > 0) {
                        if (data.categories === "No data") {
                            $("#map-no-data").removeClass("d-none");
                            $("#mc-map-goal").addClass("d-none");
                            renderChart(
                                "mc-graph-goal",
                                ["India", "(Best Performing State)", "Jammu and Kashmir", "(Best Performing UT)"],
                                [
                                    { y: 0, color: "#dd1e47" },
                                    { y: 0, color: "#00a084" },
                                    { y: 0, color: "#dd1e47" },
                                    { y: 0, color: "#ffffff" },
                                ]
                            );
                        } else {
                            $("#map-no-data").addClass("d-none");
                            $("#mc-map-goal").removeClass("d-none");

                            renderChart(
                                "mc-graph-goal",
                                data.categories,
                                data.values
                            );
                            // Set the India score
                            $("#india_score").val(data.values[0].y);

                            // Extract the state name by removing "(Best Performing State)"
                            var bestState = data.categories[1]
                                .replace("(Best Performing State)", "")
                                .trim();

                            // Extract the UT name by removing "(Best Performing UT)"
                            var bestUT = data.categories[3]
                                .replace("(Best Performing UT)", "")
                                .trim();    

                            // Set the Best Performing State dropdown
                            $("#bestPerformingState")
                                .val(bestState)
                                .trigger("change");

                            // Set the Best Performing UT dropdown    
                            $("#bestPerformingUT")
                                .val(bestUT)
                                .trigger("change");

                            // Set the Best Performing State score and show the input field
                            $("#best_state_score").val(data.values[1].y);
                            $("#best_state_score")
                                .closest(".form-group")
                                .removeClass("d-none");

                            // Set the Best Performing UT score and show the input field    
                            $("#best_ut_score").val(data.values[3].y);
                            $("#best_ut_score")
                                .closest(".form-group")
                                .removeClass("d-none");

                            // Set the Mizoram score
                            $("#jammu_and_kashmir_score").val(data.values[2].y);
                        }
                    } else {
                        renderChart(
                            "mc-graph-goal",
                            ["India", "(Best Performing State)", "Jammu and Kashmir", "(Best Performing UT)"],
                            [
                                { y: 0, color: "#dd1e47" },
                                { y: 0, color: "#00a084" },
                                { y: 0, color: "#dd1e47" },
                                { y: 0, color: "#ffffff" },
                            ]
                        );
                        $("#map-no-data").removeClass("d-none");
                        $("#mc-map-goal").addClass("d-none");
                        // if no data then reset the fields
                        $('[data-field="best-performing-ut"]').val("").trigger("change");
                        $("#best_ut_score").val(0);
                    }
                },
            });
        } else {
            
            // Reset fields when there's no goal or year selected
            $("#map-no-data").removeClass("d-none");
            $("#mc-map-goal").addClass("d-none");
            $("#india_score").val(0);
            $("#bestPerformingState").val("").trigger("change");
            $("#best_state_score").val(0);
            $("#best_state_score").closest(".form-group").addClass("d-none");
            $("#bestPerformingUT").val("").trigger("change");
            $("#best_ut_score").val(0);
            $("#best_ut_score").closest(".form-group").addClass("d-none");
            $("#jammu_and_kashmir_score").val(0); // Assuming 30 is the default score
        }
    }

    let graphChart;
    function renderChart(container, categories, values) {
        graphChart = Highcharts.chart(container, {
            chart: {
                type: "column",
                animation: { duration: 500 },
            },
            title: { text: "" },
            legend: { enabled: false },
            credits: { enabled: false },
            xAxis: {
                type: "category",
                categories: categories,
                crosshair: true,
                accessibility: { description: "States" },
            },
            yAxis: {
                max: 100,
                crosshair: true,
                tickPixelInterval: 150,
                title: { text: null },
            },
            plotOptions: {
                series: {
                    animation: true,
                    groupPadding: 0,
                    pointPadding: 0.1,
                    borderWidth: 0,
                    colorByPoint: true,
                    pointWidth: 80,
                    dataLabels: { enabled: true },
                },
            },
            series: [{ type: "column", data: values }],
        });
    }

    // Initial data fetch for default year and goal
    let initialGoal = $("[data-mc-goal].active").attr("data-mc-goal");
    let initialYear = $("[data-goal-year]").val();
    fetchGoalData(initialGoal, initialYear);

    $('[data-field="best-performing-state"]').change(function () {
        const value = $(this).val();
        
        if (value) {
            $('[data-field-wrapper="best-performing-state-input"]').removeClass(
                "d-none"
            );
        } else {
            $('[data-field-wrapper="best-performing-state-input"]').addClass(
                "d-none"
            );
        }
        graphChart.xAxis[0].categories[1] =
            `${value} (Best Performing State)` ||
            "Kerala (Best Performing State)";
        graphChart.xAxis[0].setCategories(graphChart.xAxis[0].categories);
    });

    $('[data-field="best-performing-ut"]').change(function () {
        const value = $(this).val();
        
        if (value) {
            $('[data-field-wrapper="best-performing-ut-input"]').removeClass(
                "d-none"
            );
        } else {
            $('[data-field-wrapper="best-performing-ut-input"]').addClass(
                "d-none"
            );
        }
        graphChart.xAxis[0].categories[3] =
            `${value} (Best Performing UT)` ||
            "Jammu and Kashmir (Best Performing UT)";
        graphChart.xAxis[0].setCategories(graphChart.xAxis[0].categories);
    });

    function getColor(value) {
        if (value == 100) {
            return "var(--cs-achiever)";
        } else if (value >= 65 && value < 100) {
            return "var(--cs-front_runner)";
        } else if (value >= 50 && value < 65) {
            return "var(--cs-performer)";
        } else if (value < 50) {
            return "var(--cs-cs-aspi)";
        } else {
            return "var(--cs-no_data)";
        }
    }

    document
        .querySelector(`[data-field="india"]`)
        .addEventListener("input", function () {
            const newValue = parseFloat(this.value);
            if (!isNaN(newValue) && newValue >= 0 && newValue <= 100) {
                graphChart.series[0].data[0].update({
                    y: newValue,
                    color: getColor(newValue),
                });
            }
        });

    document
        .querySelector(`[data-field="best-performing-state-input"]`)
        .addEventListener("input", function () {
            const newValue = parseFloat(this.value);
            if (!isNaN(newValue) && newValue >= 0 && newValue <= 100) {
                graphChart.series[0].data[1].update({
                    y: newValue,
                    color: getColor(newValue),
                });
            }
        });

    document
        .querySelector(`[data-field="best-performing-ut-input"]`)
        .addEventListener("input", function () {
            const newValue = parseFloat(this.value);
            if (!isNaN(newValue) && newValue >= 0 && newValue <= 100) {
                graphChart.series[0].data[3].update({
                    y: newValue,
                    color: getColor(newValue),
                });
            }
        });

    document
        .getElementById('jammu_and_kashmir_score')
        .addEventListener("input", function () {
            const newValue = parseFloat(this.value);
            if (!isNaN(newValue) && newValue >= 0 && newValue <= 100) {
                graphChart.series[0].data[2].update({
                    y: newValue,
                    color: getColor(newValue),
                });
            }
        });    
});
