<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class JobCompletedNotification extends Notification
{
    use Queueable;

    public $jobName;
    public $numberOfIndicatorsUpdated;

    public function __construct($jobName, $numberOfIndicatorsUpdated)
    {
        $this->jobName = $jobName;
        $this->numberOfIndicatorsUpdated = $numberOfIndicatorsUpdated;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject("Job {$this->jobName} Completed Successfully")
            ->line("The job ({$this->jobName}) to run the stored procedure has been completed. {$this->numberOfIndicatorsUpdated} indicators have been updated successfully.")
            ->action('View Details', url('/'))
            ->line('Thank you for using our application!');
    }
}
