<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReportingYear extends Model
{
    use HasFactory;
    
    protected $fillable = ['reporting_year', 'reporting_year_base', 'is_default', 'status', 'date_added', 'date_updated']; // Fillable fields

    public function indicatorDataEntries()
    {
        return $this->hasMany(IndicatorDataEntry::class);
    }

    public function sdgIndex()
    {
        return $this->hasMany(SdgIndex::class); 
    }
}
