<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IndicatorsToDistrict extends Model
{
    use HasFactory;

    protected $fillable = [
        'indicator_id', 'district_id', 'reporter_id', 'approver_id'
    ]; // Fillable fields

    public function indicator()
    {
        return $this->belongsTo(Indicator::class);
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function reporter()
    {
        return $this->belongsTo(User::class, 'reporter_id');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approver_id');
    }
}
