<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Indicator extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'indicator_number',
        'indicator_name',
        'unit',
        'department_id',
        'goal_id',
        'target_id',
        'is_dif',
        'is_utif',
        'is_positive_indicator',
        'baseline_year_id',
        'baseline_year',
        'date_added',
        'date_updated',
    ]; // Fillable fields

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function targets()
    {
        return $this->belongsToMany(Target::class, 'tags', 'indicator_id', 'target_id');
    }

    public function goal()
    {
        return $this->belongsTo(Goal::class);
    }

    public function scheme()
    {
        return $this->belongsTo(Scheme::class);
    }

    public function tags()
    {
        return $this->hasMany(Tag::class);
    }

    public function indicatorDataEntries()
    {
        return $this->hasMany(IndicatorDataEntry::class);
    }
}
