<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DistrictSdgIndex extends Model
{
    use HasFactory;

    protected $table = 'district_sdg_indexes';
    protected $fillable = [
        'district_id', 'goal_id', 'score', 'reporting_year_id', 'reporting_year',
        'date_added', 'date_updated'
    ]; // Fillable fields

    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function goal()
    {
        return $this->belongsTo(Goal::class);
    }

    public function reportingYear()
    {
        return $this->belongsTo(ReportingYear::class);
    }
}
